<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/6/13
 * Time: 11:12
 */
namespace Modules\Base\Transformers;

use Illuminate\Support\Traits\Macroable;
use Modules\Base\Entities\User;

class UserTransformer extends BaseTransformer
{
    use Macroable;

    protected $hideDetail = false;

    public function __construct($hideDetail = false)
    {
        $this->hideDetail = $hideDetail;
        parent::__construct();
    }

    /**
     * @OA\Schema(
     *     description="用户信息",
     *     type="object",
     *     schema="User",
     *     @OA\Property(property="id", type="integer", description="用户ID"),
     *     @OA\Property(property="name", type="string", description="用户名"),
     *     @OA\Property(property="email", type="string", description="邮箱"),
     *     @OA\Property(property="phone", type="string", description="手机号"),
     *     @OA\Property(property="created_at", type="string", description="注册时间"),
     *     @OA\Property(property="updated_at", type="string", description="更新时间")
     * )
     */
    public function transform(User $user)
    {
        $return = ['id', 'name', 'avatar', 'phone', 'sex', 'level', 'show_name2', 'is_shareholder', 'shareholder_count', 'level_title'];
        if ($this->hideDetail) {
            $phone = $user->phone;
            $user->phone = substr($phone, 0, 3).'****'.substr($phone, 7);
        } else {
            $return = array_merge($return,['email', 'avatar', 'phone', 'created_at', 'updated_at']);
        }

        return map_attr($user, $this->alter($return));
    }
}
