<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'Laravel') }}</title>

    <!-- Scripts -->
    <script src="{{ asset('js/app.js') }}" defer></script>

    <!-- Fonts -->
    <link rel="dns-prefetch" href="https://fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css?family=Nunito" rel="stylesheet" type="text/css">

    <!-- Styles -->
    <link href="{{ asset('css/app.css') }}" rel="stylesheet">
</head>
<body>
<div id="app">

    <main class="py-4">
        <div class="container">

            <div class="row justify-content-center">
                <div class="col-md-8">
                    @if($success = session()->get('success'))
                        <div class="alert alert-success alert-dismissable">
                            <h4><i class="icon fa fa-check"></i>{{ \Illuminate\Support\Arr::get($success->get('title'), 0) }}</h4>
                            <p>{!!  \Illuminate\Support\Arr::get($success->get('message'), 0) !!}</p>
                        </div>
                    @endif

                    @if($update_msg)
                        <div class="alert alert-success alert-dismissable">
                            <h4><i class="icon fa fa-check"></i>更新时间：{!!  $update_time !!}</h4>
                            @if($update_msg)<p>更新信息：{!!  $update_msg !!}</p>@endif
                            @if($version)<p>版本：{!!  $version !!}</p>@endif
                        </div>
                    @endif
                    <div class="card">
                        <div class="card-header">上传APK包</div>

                        <div class="card-body">
                            <form method="POST" action="/upload_apk" aria-label="{{ __('Login') }}"  enctype="multipart/form-data">
                                @csrf

                                <div class="form-group row">
                                    <label for="phone" class="col-sm-4 col-form-label text-md-right">APK文件</label>

                                    <div class="col-md-6">
                                        <input id="phone" type="file" class="form-control{{ $errors->has('file') ? ' is-invalid' : '' }}" name="file" value="{{ old('file') }}" required autofocus>

                                        @if ($errors->has('file'))
                                            <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('file') }}</strong>
                                    </span>
                                        @endif
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label for="password" class="col-md-4 col-form-label text-md-right">上传密码</label>

                                    <div class="col-md-6">
                                        <input id="password" type="password" class="form-control{{ $errors->has('password') ? ' is-invalid' : '' }}" name="password" required>

                                        @if ($errors->has('password'))
                                            <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('password') }}</strong>
                                    </span>
                                        @endif
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label for="version" class="col-md-4 col-form-label text-md-right">版本</label>

                                    <div class="col-md-6">
                                        <input id="version" type="text" class="form-control{{ $errors->has('version') ? ' is-invalid' : '' }}" name="version" value="{{ old('version') }}" required>

                                        @if ($errors->has('version'))
                                            <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('version') }}</strong>
                                    </span>
                                        @endif
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label for="update_msg" class="col-md-4 col-form-label text-md-right">更新信息</label>

                                    <div class="col-md-6">
                                        <textarea id="update_msg"  class="form-control{{ $errors->has('update_msg') ? ' is-invalid' : '' }}" name="update_msg" required>{{old('update_msg')}}</textarea>

                                        @if ($errors->has('update_msg'))
                                            <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('update_msg') }}</strong>
                                    </span>
                                        @endif
                                    </div>
                                </div>

                                <div class="form-group row mb-0">
                                    <div class="col-md-8 offset-md-4">
                                        <button type="submit" class="btn btn-primary">
                                            {{ __('上传') }}
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
</div>
</body>
</html>
