<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/6/8
 * Time: 12:20
 */
namespace Modules\Share\Transformers;

use Modules\Share\Entities\Scheme;

class SchemeTransformer extends BaseTransformer
{
    /**
     * @OA\Schema(
     *     description="方案列表",
     *     type="object",
     *     schema="Scheme",
     *     @OA\Property(property="id", type="integer", description="ID"),
     *     @OA\Property(property="name", type="string", description="方案名称"),
     *     @OA\Property(property="direct_source_ratio", type="integer", description="直接客源奖励比例"),
     *     @OA\Property(property="indirect_source_ratio", type="integer", description="间接客源奖励比例"),
     *     @OA\Property(property="recharge_amount", type="float", description="充值金额"),
     *     @OA\Property(property="consume_amount", type="float", description="可消费充值金额"),
     *     @OA\Property(property="unconsume_amount", type="float", description="不可消费充值金额"),
     *     @OA\Property(property="online_pay", type="integer", description="是否线上支付"),
     *     @OA\Property(property="dividend_type", type="integer", description="分红方式"),
     *     @OA\Property(property="benefit_month", type="integer", description="受益时长/月"),
     *     @OA\Property(property="interests_images", type="string", description="方案权益"),
     *     @OA\Property(property="status", type="integer", description="启用状态"),
     *     @OA\Property(property="created_at", type="string", description="写入时间"),
     *     @OA\Property(property="updated_at", type="string", description="更新时间")
     * )
     */
    public function transform(Scheme $scheme)
    {
        return map_attr($scheme, ['id', 'name', 'direct_source_ratio', 'indirect_source_ratio','recharge_amount','consume_amount','unconsume_amount','online_pay','dividend_type','benefit_month','interests_images', 'status', 'created_at', 'updated_at']);
    }
}
