<?php

namespace Modules\Share\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class SchemeRequest extends BaseRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function postRules()
    {
        return [
            'name' => 'required',
            'direct_source_ratio' => 'required|Numeric|between:0,100',
            'indirect_source_ratio' => 'required|Numeric|between:0,100',
            'recharge_amount' => 'required|Numeric|between:1,99999999',
            'consume_amount' => 'required|Numeric',
            'unconsume_amount' => 'required|Numeric',
            'online_pay' => 'required',
            'dividend_type' => 'required',
            'benefit_month' => 'required',
            'interests_images' => 'required',

        ];
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function putRules()
    {
        return [
            'id' => 'required',
            'name' => 'required',
            'direct_source_ratio' => 'required|Numeric|between:0,100',
            'indirect_source_ratio' => 'required|Numeric|between:0,100',
            'recharge_amount' => 'required|Numeric|between:1,99999999',
            'consume_amount' => 'required|Numeric',
            'unconsume_amount' => 'required|Numeric',
            'online_pay' => 'required',
            'dividend_type' => 'required',
            'benefit_month' => 'required',
            'interests_images' => 'required',
        ];
    }

    public function messages()
    {
        return [
            'id.required' => '方案ID不能为空',
            'name.required' => '方案名称不能为空',
            'direct_source_ratio.required' => '直接客源奖励比例不能为空',
            'direct_source_ratio.between' => '直接客源奖励比例必须介于 0 - 100 之间',
            'indirect_source_ratio.required' => '间接客源奖励不能为空',
            'indirect_source_ratio.between' => '间接客源奖励必须介于 0 - 100 之间',
            'recharge_amount.required' => '充值金额不能为空',
            'recharge_amount.between' => '充值金额必须为1-99999999元之间',
            'consume_amount.required' => '可消费充值金额不能为空',
            'unconsume_amount.required' => '不可消费充值金额不能为空',
            'online_pay.required' => '是否线上支付不能为空',
            'dividend_type.required' => '分红方式不能为空',
            'benefit_month.required' => '受益时长不能为空',
            'interests_images.required' => '方案权益不能为空',
        ];
    }

}
