<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSchemeConfigsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        /**
         * 奖励方案配置
         */
        Schema::create('scheme_configs', function (Blueprint $table) {
            $table->increments('id');
            $table->tinyInteger('introduce_manager_ratio')->comment('介绍掌柜奖励比例');
            $table->tinyInteger('default_manager_ratio')->comment('默认奖励比例');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('scheme_configs');
    }
}
