<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSchemesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        /**
         * 奖励方案列表
         */
        Schema::create('schemes', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name', '100')->default('')->comment('方案名称');
            $table->tinyInteger('direct_source_ratio')->default(0)->comment('直接客源奖励比例');
            $table->tinyInteger('indirect_source_ratio')->default(0)->comment('间接客源奖励比例');
            $table->decimal('recharge_amount', 10, 2)->default(0)->comment('充值金额');
            $table->decimal('consume_amount', 10, 2)->default(0)->comment('可消费充值金额');
            $table->decimal('unconsume_amount', 10, 2)->default(0)->comment('不可消费充值金额');
            $table->tinyInteger('online_pay')->default(0)->comment('是否线上支付 0否 1是');
            $table->tinyInteger('dividend_type')->default(1)->comment('分红方式 1毛利分红 2实收分红');
            $table->tinyInteger('benefit_month')->default(0)->comment('受益时长/月');
            $table->tinyInteger('status')->default(1)->comment('启用状态 1启用 2停用');
            $table->string('interests_images','200')->default('')->comment('方案权益图片');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('schemes');
    }
}
