<?php

namespace Modules\Project\Http\Controllers\Api;

use Modules\Base\Http\Controllers\Api\ApiController;

class ConfigController extends ApiController
{
    /**
     * 配置信息
     *
     * @return mixed
     *
     * @OA\Get(
     *     tags={"基础接口"},
     *     summary="配置信息",
     *     path="/api/configs",
     *     @OA\Response(
     *          response="200",
     *          description="成功",
     *          @OA\MediaType(
     *             mediaType="application/json",
     *              @OA\Schema(
     *                  type="object",
     *                  @OA\Property(
     *                      property="data",
     *                      type="array",
     *                      @OA\Items(),
     *                      description="配置项"
     *                  ),
     *              )
     *          )
     *      )
     * )
     */
    public function index()
    {
        $config = [
            //'point_convert_fee_rate' => db_config('point_convert_fee_rate', 0.13),
            //'shop_point_rate' => db_config('shop_point_rate', 0.2),
        ];

        return $this->response->array(['data' => $config]);
    }
}
