<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1"/>
    <title>{{ config('app.name', 'Laravel') }} 下载</title>
</head>
<body>
<style type="text/css">
    * {
        margin: 0;
        padding: 0;
    }

    img {
        max-width: 100%;
        height: auto;
    }

    .test {
        height: 600px;
        max-width: 600px;
        font-size: 20px;
    }

    body,
    html {
        width: 100%;
        height: 100%;
        background: url("data:image/jpeg;base64,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") no-repeat center;
        background-size: cover;
        position: relative;
        overflow: hidden;
    }

    .Android,
    .ios {
        position: fixed;
        bottom: 20%;
        left: 50%;
        z-index: 999;
        left: 50%;
        margin-left: -150px;
    }

    .ios {
        bottom: 8%;
    }
</style>
<a href="{{ $download_url }}" class="Android"><img class="down_img" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAASwAAABGCAYAAAB2Zan9AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAA4RpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMy1jMDExIDY2LjE0NTY2MSwgMjAxMi8wMi8wNi0xNDo1NjoyNyAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9tbS8iIHhtbG5zOnN0UmVmPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VSZWYjIiB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtcE1NOk9yaWdpbmFsRG9jdW1lbnRJRD0ieG1wLmRpZDozNzk0YjBjZS0yNDdlLTY1NDktOGUxNC03MTFhNGNmYzI4NjMiIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6RkUxMDhCNzExMzYwMTFFN0EzMDlFQTU4MDg4RTQyQzQiIHhtcE1NOkluc3RhbmNlSUQ9InhtcC5paWQ6RkUxMDhCNzAxMzYwMTFFN0EzMDlFQTU4MDg4RTQyQzQiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENDIDIwMTcgKFdpbmRvd3MpIj4gPHhtcE1NOkRlcml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6NWRkZDc1ZjItNGEzNS02ZjQwLWJhZGYtMmM2MzAyNWEyMmJmIiBzdFJlZjpkb2N1bWVudElEPSJhZG9iZTpkb2NpZDpwaG90b3Nob3A6ZjJhZGNjMTctMGZhZi0xMWU3LWExZDItOGE2ZGNiOGQ1YmUyIi8+IDwvcmRmOkRlc2NyaXB0aW9uPiA8L3JkZjpSREY+IDwveDp4bXBtZXRhPiA8P3hwYWNrZXQgZW5kPSJyIj8+UidiQwAACwxJREFUeNrsnV2MG1cVx+8kbdq0SstW4oVAqbziQ0KAhLeCVHyE4n2kbWh3oQ8IeFlTyhM8eOGRh2pdtQ+o0HZXqELqE3FLv/KC7H6oQBuiuKgUpH6wFipFSDxkQwM0CQ3D/9jnJncnM/aM47HnTv4/6cjj8Xx47tz5zznn3rkThOG7JoZdsFvU9sHep/MIISQP/gV7C/Z72GOwJ2CnowsFMYJ1AHY37E3YL2DP6PRplikhJCfEIboWdiPsqzrdgP0ySbB2wu6C3QS7A/Ycy5AQMiP2wx6APQn7IexMVLCasM/Avgx7m+VFCJkxe2BPwX6n3pbZoT/cBrtZvSuKFSGkCJxwdOk262FJ7Phn2O2w37KMCCEF4wYzyKfPi4e1BHuNYkUIKSgvwF6FLYtgSdeFgywTQkiBEY26RQTretizLA9CSIGR7lULksM6iYmrDPtZEUKKi+TaT4hghZgIWB6EkIIT7mAZEEJ8gYJFCKFgEUIIBSs1Ow/B9gXBJSaLyTqDdQkhFKzp8SDsnjHWu0fXJYQUjNK2Eoq3FIbh05i8PwiCRzF9DaY/DfswbE4XOw57A/YiljmGZW7F9Hcw/aWEccIIIbMjLLtgLWDyEVgP9oUhHqWUwa9h18GWIFhHKFiEULAmIkSpjiwMP4WPh2CfzLiLP8FWIFovpNsPhY2QaQlWKXNYEKtv4ePwGGIlfAz2PLZxB+sHIcWidIIFofmGelaX6qwzGVa3y8roq/djW99mFSGEgpWXWH0cH+vOLHlgcrcZDP08irt02Wecefdhm9ezmhBCwcqD+2CXRY5vh3pMo9jpLG+RhNkDrCaEFIPSJN3VEzoS91OG40ta9otBEDwXv99iJd1PnTxdM4Pxr5cv333F1sVasdkYUs7TWiYP69Ykjcuihwnzv+JROdTU1stcc0++858VWCifRb2x5mW4Ka3DQlgl5rc5/a2U579MglXNcdsLvhTCZZfvWjWDfmdLuJjXpiwiNRWRRg7bXtdt1zJ6nHIBNyLW1ou6WrYLOupVi6jBjsKWynB8l5ToXL03x21f4VlZ1GFtc65H/7RZSymW87jAehMUtbZ6l3KhpllFLuLuCMHbxEdljP8yapEejn0+x3NQcW7kMn0Qx9KSuoGbmrepAi8FKwxDebxmH2wzCILf6Gx5W+zunHb5jrPvz8qFZgaP87w+zeNGhVvJGOqtpAiZVnHhNEue+2hFhQkXrRfHrN5qkvhvRoRxA+dSblZbznG2UG86ZjAmugh0Fd8XMb/n44n0TrAgGF/Hx89tOIvvP4VwfFcr5bU57fZN2Cewr5/g806d9z98/6YxZx42pFAiiH0Hk0q648Ie6QVpvkhuDKtWCNM+kZHiWGR7zWh4rPtL8lC3Iscg3xfxP0X4tnwVK189rHvN9tzbnRCOH5vBuPRX57TPq7CPDzliZfQ/yH+ZhWCJW78xbIFRF4zmgtrU1tIyFyO+q74flI+CFZer2juF/e5N+V9KjyS/RywyKoc10dxVict5WDgYFxJGPb9h56kDAVukYJGZIS1gZpB03tAQuYy0IxfpuoZIi66gpki699KEe7MkIRy051jC7m6C0PXzVTi+0o3CQsHyCA0DNxLEqqp3Y/FcuikuBknEXkiF7mAbme7QTu6lzDcNaVXs4VjrOXmRUn4VPc9JlLbDMAWrHBeJVOC2VtRptQDVUoSGebCoYpsUQvVDTgmXRNxRFvVIWUlu51gaUR8D2f+cCoqEa03814nljTTvKNtujXiKoWfrha0LetxSR1q+tJBSsPwP99L0bdqUcChFPyAX2xxeCsSzwfHLBR3XMdR2PM1DsJoqFmsqLA3tViLe1lghesJNYWnIzcL1el1PbEnLw+tUAd+aQy4kJAyyWFI4mxNyoVbVs3CxItbJKWxvaW7Melay/4PSqRWWuQOqU3Z2e/UR5dxxRKoS8f62pnwOKFgXK+LGSxI1ao6nsOjOjxELW+GbMZXcJ++qrY/ohCMeA+pEPCrjeBrSF6mb55/UhPk1jkDUNEzMnMPDOnOO4LSs56U9+xNDQitY2uFYpps+93JnSFiOMLGquZpOigpvJniHnVUOKy0tPeaavch1JIuKibS85ShaIg51lJPsf133La2a8luW87CintpqmhE4pPVQUwIV9TDXyuBd0cPyW6xsq6BxvKck1rTCb5Sg/9O8eoxxLZQVvTCNelD9h8CdsHDSop1WuDr63OCqerip9683m5UxBKerYm3PvffeFQXLb6rmXPP1MR1ypBZT4Rta4XsphC0LnYQ81bDf8haKitnepN/Ui7WhoxXU1BudiWhLmDhGq6Ftdey3btpQ2PVyHduMhMRW7Lo+twwyJCwBtk+W5ieWtGKu4HtXQ6Cm01NaLuKJDejnCFPW9SRXVr8AMTJJHiKOtep4FmfLSMNmm//ZmlY4OEGRk+MNYo43NMP7wrk5utK0APsoWP+GXRmZd3wK+z2e8F+KIlxVFa5+Xst5NMaK1dhJZk0UZxklIkt+q54yRKqa4Z0lk7oruEPtLPv84G9G7PhX2xoYnP5YG6OeR2VIOBnujnz/FezlKez3Zd3XsP8yS+Hq6sOtzZiQYiXrwHdFQvM4c2Z436klJxSyF2fFbO+71tB5vpaD9L9qOC2jFf3edkNFvVnZ8phTL9wVfjtGFj2svAmC4EdhGL6Eyc/DZDyqhzEPs8K89yv7uBmTMryNjMf1POYdKsLY4Zq7smO5W2yuxIaMUtnlgm9m7cSoHtBGyotqVKgyDkM7e6oY9z0w60lqzmpdhW7DKQsZfXN5WKtqwYT6mH7tJZyDnlvWKmYNLSvxLo+qULc06V51PG8K1pRE6xA+Ds1gv6fw8bMilIHmZow5v/d7U0XJVsimhnS2C4R0YuxXfo8G7jvPe4qw5hyrbT21Ind2jCp9IFrKoq2jb64WOUTUcxgkiNmailXLmWef1RSxkn55WzjOVS0PeSB60SmXDgVrtvwD9sEct10EkVqLeFGW/oiaSS1B1kNyhKsfKolnMmFPKC8voz+UcUIermLOPYLSVY/CeiR115OS5wq1UWJdt1nD9wXf81paRgdVjOR4l20XBqkT1gN3hpvp5d1xljms0dzr6baz0FRXvqshX117ti+nabYW4dL+QHUnZCg0tvPlkJC0p+VSV0GTcpGE8nxc2KeJ5gXHC/E+Ca9lJMcqD0UvRluDddyrphMKettqWJr3Ego63vpNsF1m8ELVuFfNPwp7S6ffb+JfD/agODQwiSGedMaNj9kn339HyJQISyVYEfF6j4lPLJ59KSqW2Y+PZ2OWmcMyx9Pth4JFyLQEiz3dCSHeQMEihFCwCCGEgkUIoWCVkKTXprybMJ1mXUIIBWvyBEEgI5hFO8e9DXvF+f6KznPp6rqEEArWVPka7LBOSwfBAxCjfzqiJtMHzLlRAA7rOoSQIjoivvXDIoRctLAfFiGEISEhhFCwCCEXt2CdgO1hURBCCowMaHBaBOvvsL0sD0JIgfmAaJUI1h9gn2N5EEIKzI2woyJYj8OWWR6EkAIjGvW4CJYMr/sR2A0sE0JIAdkH+6holQiWPDf3fTN4ucLVLBtCSIEQTXoI9j3YKdutQbwseQvNE4YthoSQYrBHNekp1aht/bB+YAYPAx+B7WdZEUJmyH7Voj+qNvUJYsYkl5cyyOuk/mIGrw56GvZX2H9ZhoSQnLjSDLouSI8FSbBfp0L1iLtQkPASBemkJe9tk5EM5MWU0k/rUpYpISQnxCH6mxkMCfWYhoDnjUv3fwEGAFj6kj87lwvqAAAAAElFTkSuQmCC" alt=""></a>
<div class="test">
    {{--<a href="/{{ config('package.info.name', 'uploads/apk/latest.apk') }}">下载Android安装包</a><br />--}}
    {{--<span><b>{{$update_msg}}</b></span><br /><br /><br />--}}
    {{--<span><b>更新内容：</b></span><br /><span>{{$apk_update_message}}</span>--}}
</div>
<script type="text/javascript">

    function is_weixin() {
        var ua = navigator.userAgent.toLowerCase();
        if (ua.match(/MicroMessenger/i) == "micromessenger") {
            return true;
        } else {
            return false;
        }
    }
    function is_QQ() {
        var ua = navigator.userAgent.toLowerCase();
        if (ua.match(/mobile mQQBrowser/i) == "mobile mqqbrowser") {
            return true;
        } else {
            return false;
        }
    }
    var u = navigator.userAgent;
    var isAndroid = u.indexOf('Android') > -1 || u.indexOf('Adr') > -1; //android终端
    var isiOS = !!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/); //ios终端
    var isWeixin = is_weixin();
    var isQq = is_QQ();

    function loadHtml() {
        var div = document.createElement('div');
        div.id = 'weixin-tip';
        div.innerHTML = '<p><img src="data:image/png;base64,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" alt="微信打开"/></p>';
        document.body.appendChild(div);
    }

    function loadStyleText(cssText) {
        var style = document.createElement('style');
        style.rel = 'stylesheet';
        style.type = 'text/css';
        try {
            style.appendChild(document.createTextNode(cssText));
        } catch (e) {
            style.styleSheet.cssText = cssText; //ie9以下
        }
        var head = document.getElementsByTagName("head")[0]; //head标签之间加上style样式
        head.appendChild(style);
    }
    var cssText = "#weixin-tip{position: fixed; left:0; top:0; background: rgba(0,0,0,0.8); filter:alpha(opacity=80); width: 100%; height:100%; z-index: 9999;} #weixin-tip p{text-align: center; margin-top: 10%; padding:0 5%;}";

    if (isWeixin || isQq) {
        loadHtml();
        loadStyleText(cssText);
    }else{
        if ( isAndroid ){
            android();
        } else if ( isiOS ){
            ios();
        }
    }

    function android(){
        window.location.href = "{{ config('package.info.android_url_schemes', 'love') }}://"+ getParam();
        window.setTimeout(function(){
            window.location.href = "/{{ config('package.info.name', 'uploads/apk/latest.apk') }}";
        },2000);
    };
    function ios(){
        window.location.href = "{{ config('package.info.ios_url_schemes', 'love') }}://" + getParam();
        window.setTimeout(function(){
        },2000)
    };

    function getParam(){
        return window.location.search;
    }

</script>
</body>
</html>