<?php

namespace Modules\Base\Http\Requests;

use Modules\Base\Services\SmsService;

class SmsLoginRequest extends BaseRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'phone' => 'bail|required|regex:/^1[23456789][0-9]{9}$/',
            'code' => 'required|string|check_sms:'.$this->phone.','. SmsService::LOGIN,
            //'password' => 'required|string|min:6',
        ];
    }
}
