<?php

namespace SMG\Blog;

use Illuminate\Support\ServiceProvider;

class BlogServiceProvider extends ServiceProvider
{
    /**
     * {@inheritdoc}
     */
    public function boot(Blog $extension)
    {
        if (! Blog::boot()) {
            return ;
        }

        if ($views = $extension->views()) {
            $this->loadViewsFrom($views, 'blog');
        }

        if ($this->app->runningInConsole() && $assets = $extension->assets()) {
            $this->publishes(
                [$assets => public_path('vendor/laravel-admin-ext/blog')],
                'blog'
            );
        }

        $this->app->booted(function () {
            Blog::routes(__DIR__.'/../routes/web.php');
        });
    }
}