# 积木平台
下面介绍的是目前积木包的一些情况，和思路。有不同见解的小伙伴，欢迎提出。


## 关于模块复用解耦
首先来介绍一下laravel-follow
https://github.com/overtrue/laravel-follow
这是一个Model添加点赞和收藏功能的包，非常的简单，不需要考虑其他关联关系。

首先，在 User 模型中引入 CanFollow 以及 CanBeFollowed ：
```php
use Overtrue\LaravelFollow\CanFollow;
use Overtrue\LaravelFollow\CanBeFollowed;

class User extends Model
{
    use CanFollow, CanBeFollowed;
}
```
关注用户：
```
$user->follow(1);

// or

$user->follow([1,2,3,4]);

// or

$target = User::find(2);

$user->follow($target);
```
取消关注用户：
```
$user->unfollow(1);

// or

$user->unfollow([1,2,3,4]);

// or

$target = User::find(2);

$user->unfollow($target);
```
获取用户的关注者：
```
$user->followers();
```
获取用户关注的用户：
```
$user->followings();
```

### 积木现状
我们希望积木包达到的状态和`laravel-follow`类似，包与包之间尽量解耦，并且功能可以完美复用。

在SMG的包中有两类， 应用型和工具型。
一. 工具型(一般配合其他代码使用)
+ 地址
   http://source.shengmage.com/smg/address
   参照README.md安装，可以实现多个模型同时使用地址，比如 会员 和 店铺都有地址，只需要在各自的model中 `use HaveAddress;` 即可
+ 钱包 http://source.shengmage.com/smg/wallet
+ 支付 http://source.shengmage.com/smg/pay
+ 等...

###   

二. 应用型
+ 文章 http://source.shengmage.com/smg/page
+ 广告 http://source.shengmage.com/smg/slider
+ 商城 http://source.shengmage.com/smg/product
+ 等...
+ 


现在比较稳定的包有
+ http://source.shengmage.com/smg/area
+ http://source.shengmage.com/smg/address
+ http://source.shengmage.com/smg/support
+ http://source.shengmage.com/smg/admin
+ http://source.shengmage.com/smg/bankcard
+ http://source.shengmage.com/smg/page
+ http://source.shengmage.com/smg/wallet
+ http://source.shengmage.com/smg/real-name
+ http://source.shengmage.com/smg/slider
+ http://source.shengmage.com/smg/pay
+ http://source.shengmage.com/smg/express
+ http://source.shengmage.com/smg/categories

##### 包的扩展性

问题： 虽然设计包的时候也想尽量通用，但总有各种原因使得不那么完美，经常会因为扩展而头痛，比如我只想在他原来的基础上增加一个字段，但是这个字段并不通用，修改包和不修改包是一个问题。

解决方法： 
1. 邵教授在admin 基础包中增加了一些钩子 。 可以在不修改包的情况下，修改后台表单，表格，修改接口返回。文档地址： http://source.shengmage.com/smg/admin
2. 大部分包都会`use Macroable`  , Macroable 的作用在于为对象增加方法， 一些介绍：https://laravel-china.org/topics/2915/how-to-use-the-macro-method-to-extend-the-function-of-the-base-class-of-laravel 。





## 关于接口返回结构
以商品分类为例
```php
class ProductCategoryTransformer extends BaseTransformer
{
    use Macroable;

    protected $is_list;

    protected $availableIncludes = ['children'];

    public function transform(ProductCategory $table)
    {
        return map_attr($table, ['id', 'parent_id', 'name', 'image', 'created_at', 'updated_at']);
    }

    public function includeChildren(ProductCategory $table)
    {
        return $this->collection($table->children, new ProductCategoryTransformer());
    }
}
```
这种写法默认只返回 transform 中的信息，如果需要接口返回 分类的子分类 在链接中增加 ?include=children (需要model中有对应的关联关系)

##### 在不修改包的情况下，修改接口返回
```php
\SMG\Support\Hook\Facades\Hook::addFilter('map_attr.return', function($return,$model) {
            if($model instanceof ProductCategory){
                $return['test'] = '123';
            }
            return $return;
        }, 20, 2);
```
如果原来返回的是 
```
[
    [
    'a' => 1,
    'b' => 2,
    ]
]
```
用后用变为 
```
[
    [
    'a' => 1,
    'b' => 2,
    'test' => 123
    ]
]
```




## API接口 返回规定

+ GET 获取资源    正常返回200

+ POST 创建资源   成功返回 201

+ PUT 修改资源   成功  有返回 资源  200，  没有返回内容 204

+ DELETE  删除资源  200


### 其它一切错误和需要返回错误的通通 抛异常


常用 异常代码 

+ 400 错误的请求
+ 403 没有权限
+ 404 资源不存在 
+ 405 操作方法不允许

+ 422  参数验证错误
+ 500  程序错误

一般类型的错误 都 可以抛 500，  需要特殊  异常确定的 可以抛出自定义异常 （或者 \Exception 时 传第二个参数，如果只是仅需要特殊的异常编号)

## clone 一份新代码后的步骤


1. `composer install`

2. 修改 .env 文件 里的数据库配置信息 

3. 执行 `php base:install`


## 一般常规操作

1. 建立模型和数据表
`php artisan module:make-model -m Feedback Project`

2. 设计好字段后执行 `php artisan migrate`
（期间如果有需要修改，可先执行 `php artisan migrate:rollback` 回滚，修改 migration文件后再 `php artisan migrate`，已经提交过的migrate不允许再次修改！！！！）

3. 建立 ApiController 并修改
`php artisan module:make-controller Api/FeedbackController Project`

4. Resquest 文件， `php artisan module:make-request FeedbackRequest Project`

5. Transformer文件

6. routes.php加入路由

7. 后台Controller文件
php artisan admin:make --model=Modules\\Project\\Entities\\Feedback FeedbackController
这个生成后在 \app\Admin\Controllers 文件夹，需要手动移动至  \Modules\Project\Http\Controllers\Admin 文件夹

8. routes.php加入后台路由



## 一些优秀的扩展包
名称|GIT|描述
--|:--:|--:
intervention/image|https://github.com/Intervention/image|图片处理扩展包，支持裁剪、水印等处理，使用教程请见 https://laravel-china.org/topics/1903
dingo/api|https://github.com/dingo/api|构建 API 服务器的完整解决方案，教程：https://laravel-china.org/topics/1159
simplesoftwareio/simple-qrcode|https://github.com/SimpleSoftwareIO/simple-qrcode|二维码生成工具
Crinsane/LaravelShoppingcart|https://github.com/Crinsane/LaravelShoppingcart|购物车
overtrue/laravel-follow|https://github.com/overtrue/laravel-follow|关注和点赞