//app.js
import myhttp from "./utils/http.js"
App({
  detailPageParam: null,
  isDistributorMember: {
    status: 0
  },

  init: function() {
    //调用API从本地缓存中获取数据
    var logs = wx.getStorageSync('logs') || []
    logs.unshift(Date.now())
    wx.setStorageSync('logs', logs)

  },

  onLaunch: function() {
    var that = this
    console.log('小程序开始运行');
    // 展示本地存储能力
    var logs = wx.getStorageSync('logs') || []
    logs.unshift(Date.now())
    wx.setStorageSync('logs', logs)

    // 登录
    wx.login({
      success: res => {
        this.globalData.code = res.code
        console.log(res.code)
        // 发送 res.code 到后台换取 openId, sessionKey, unionId  

        myhttp.HttpRequst("base/authorizations/openlogin/wx_mini?include=user", {
          code: res.code
        }, "POST", function(res) {

          wx.setStorageSync('access_token', res.data.data);
          if (that.loginReadyCallback) {
            console.log('a')
            that.loginReadyCallback()
          }
          that.globalData.isLogin = true;

          // that.updateUser();     
        });

      }
    })
    // 获取用户信息
    wx.getSetting({
      success: res => {
        if (res.authSetting['scope.userInfo']) {
          // 已经授权，可以直接调用 getUserInfo 获取头像昵称，不会弹框
          this.getUserInfo()
        }
      }
    })
  },

  globalData: {
    imgSuffix:'https://xcx.885505.com/uploads/',
    userInfo: null,
    auth: false,
    code: null,
    isLogin: false
  },
  getUserInfo: function() {
    wx.getUserInfo({
      success: res => {
        // 可以将 res 发送给后台解码出 unionId
        this.globalData.userInfo = res.userInfo

        this.updateUserInfo(res.userInfo)
      }
    })
  },
  auth: function() {
    if (!this.globalData.userInfo) {
      wx.getSetting({
        success: res => {
          if (!res.authSetting['scope.userInfo']) {
            wx.navigateTo({
              url: '/pages/auth/auth',
            })
          } else {
            //this.getUserInfo()
          }
        }
      })
    }
  },
  updateUserInfo: function(userInfo) {
    this.globalData.userInfo = userInfo
    console.log('updateUserInfo')
    if (this.userInfoReadyCallback) {
      this.userInfoReadyCallback()
    }

    this.updateUser()
  },
  updateUser: function() {
    if (this.globalData.userInfo) {
      var token = wx.getStorageSync('access_token')
      console.log(token)
      if (!token.user.data.name) {
        console.log('update user!')
        //return false;
        let data = {
          name: this.globalData.userInfo.nickName,
          avatar: this.globalData.userInfo.avatarUrl,
          sex: this.globalData.userInfo.gender
        }
        myhttp.HttpRequst("base/user", {
          name: data.name,
          avatar: data.avatar,
          sex: data.sex
        }, "PUT", function(res) {

          if (res.statusCode != 200) {

          } else {
            token.user = res.data.data;
            wx.setStorageSync('token', token);
          }
        });
      }
    }

  },
  getUser: function() {
    var token = wx.getStorageSync('access_token')
    if (!token) return false
    return token.user.data
  }
})