<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/6/8
 * Time: 12:20
 */
namespace Modules\Project\Tranaformers;

use Modules\Project\Entities\UserWallet;
use Modules\Project\Entities\UserWalletLog;

class UserWalletLogTransformer extends BaseTransformer
{
    protected $availableIncludes = ['order'];

    /**
     * @OA\Schema(
     *     description="钱包日志",
     *     type="object",
     *     schema="UserWalletLog",
     *     @OA\Property(property="id", type="integer", description="ID"),
     *     @OA\Property(property="user_id", type="integer", description="用户ID"),
     *     @OA\Property(property="value", type="number", description="变动值"),
     *     @OA\Property(property="type", type="integer", description="变动类型"),
     *     @OA\Property(property="type_name", type="string", description="变动类型名称"),
     *     @OA\Property(property="type_id", type="integer", description="类型ID"),
     *     @OA\Property(property="wallet_type", type="string", description="值类型"),
     *     @OA\Property(property="created_at", type="string", description="创建时间"),
     *     @OA\Property(property="order", type="object", description="订单",  @OA\Property(property="data", type="object", ref="#/components/schemas/Order"))
     * )
     */
    public function transform(UserWalletLog $userWalletLog)
    {
        return map_attr(
            $userWalletLog,
            [
                'id', 'user_id', 'value', 'type', 'type_name', 'type_id', 'wallet_type', 'created_at', 'updated_at',
            ]
        );
    }

    public function includeOrder($userWalletLog)
    {
        if (!in_array($userWalletLog->type, [UserWallet::PAY_ORDER,UserWallet::ORDER_REWARD])) {
            return null;
        }

        return $this->item($userWalletLog->order, new OrderTransformer());
    }
}
