<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/6/8
 * Time: 12:20
 */
namespace Modules\Project\Tranaformers;

use Modules\Base\Tranaformers\UserTransformer;
use Modules\Project\Entities\Order;
use SMG\Address\AddressTransformer;

class OrderTransformer extends BaseTransformer
{
    protected $availableIncludes = ['orderGoods','address','express','user'];

    /**
     * @OA\Schema(
     *     description="订单",
     *     type="object",
     *     schema="Order",
     *     @OA\Property(property="id", type="integer", description="ID"),
     *     @OA\Property(property="user_id", type="string", description="用户id"),
     *     @OA\Property(property="goods_price", type="string",description="总价"),
     *     @OA\Property(property="discount_amount", type="string", description="优惠金额"),
     *     @OA\Property(property="payable_amount", type="string", description="应付金额"),
     *     @OA\Property(property="paid_amount", type="string", description="已支付金额"),
     *     @OA\Property(property="freight", type="string", description="运费金额"),
     *     @OA\Property(property="status", type="string", description="状态"),
     *     @OA\Property(property="remarks", type="string", description="备注"),
     *     @OA\Property(property="tracking_no", type="string", description="快递号"),
     *     @OA\Property(property="express", type="object", ref="#/components/schemas/express"),
     *     @OA\Property(property="created_at", type="string", description="注册时间"),
     *     @OA\Property(property="updated_at", type="string", description="更新时间"),
     *     @OA\Property(property="expires_at", type="string", description="过期时间")
     * )
     */
    public function transform(Order $table)
    {
        return [
            'id' => $table->id,
            'order_no' => $table->order_no,
            'user_id' => $table->user_id,
            'goods_price' => $table->goods_price,
            'cover_picture' => $table->cover_picture,
            'discount_amount' => $table->discount_amount,
            'payable_amount' => $table->payable_amount,
            'paid_amount' => $table->paid_amount,
            'freight' => $table->freight,
            'status' => $table->status,
            'tracking_no' => $table->tracking_no,
            'remarks' => $table->remarks,
            'created_at' => $table->created_at->toDateTimeString(),
            'updated_at' => $table->updated_at->toDateTimeString(),
            'expires_at' => $table->expires_at,
            'shipped_at' => $table->shipped_at,
        ];
    }

    public function includeOrderGoods(Order $table)
    {
        return $this->collection($table->orderGoods, new OrderGoodsTransformer());
    }

    public function includeAddress(Order $table)
    {
        if ($table->address) {
            return $this->item($table->address, new AddressTransformer());
        } else {
        }
    }

    public function includeExpress(Order $table)
    {
        if ($table->express) {
            return $this->item($table->express, new ExpressTransformer());
        } else {
        }
    }

    public function includeUser(Order $table)
    {
        return $this->item($table->user, new UserTransformer());
    }
}
