<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/6/8
 * Time: 12:20
 */
namespace Modules\Project\Tranaformers;

use Modules\Project\Entities\OrderGoods;

class OrderGoodsTransformer extends BaseTransformer
{
    /**
     * @OA\Schema(
     *     description="订单商品",
     *     type="object",
     *     schema="OrderGoods",
     *     @OA\Property(property="id", type="integer", description="ID"),
     *     @OA\Property(property="order_id", type="string", description="订单id"),
     *     @OA\Property(property="goods_id", type="string",description="商品id"),
     *     @OA\Property(property="goods_title", type="string",description="商品标题"),
     *     @OA\Property(property="spec", type="string", description="规格"),
     *     @OA\Property(property="qty", type="string", description="购买数量"),
     *     @OA\Property(property="selling_price", type="string", description="售价"),
     *     @OA\Property(property="total_price", type="string", description="总金额"),
     *     @OA\Property(property="remarks", type="string", description="备注"),
     *     @OA\Property(property="created_at", type="string", description="注册时间"),
     *     @OA\Property(property="updated_at", type="string", description="更新时间")
     * )
     */
    public function transform(OrderGoods $table)
    {
        $spec = json_decode($table->spec);

        return [
            'id' => $table->id,
            'order_id' => $table->order_id,
            'goods_id' => $table->goods_id,
            'goods_title' => $table->goods_title,
            'cover_picture' => $table->goods ? $table->goods->cover_picture : '',
            'spec' => $spec,
            'qty' => $table->qty,
            'selling_price' => $table->selling_price,
            'total_price' => $table->total_price,
            'remarks' => $table->remarks,
            'created_at' => $table->created_at->toDateTimeString(),
            'updated_at' => $table->updated_at->toDateTimeString(),
        ];
    }
}
