<?php
namespace Modules\Project\Tranaformers;

use Modules\Project\Entities\Express;

class ExpressTransformer extends BaseTransformer
{
    /**
     * @OA\Schema(
     *     description="快递",
     *     type="object",
     *     schema="express",
     *     @OA\Property(property="id", type="integer", description="ID"),
     *     @OA\Property(property="name", type="string", description="快递名称"),
     * )
     */
    public function transform(Express $table)
    {
        return [
            'id' => $table->id,
            'name' => $table->name,
        ];
    }
}
