<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/6/8
 * Time: 12:20
 */
namespace Modules\Project\Tranaformers;

use Modules\Project\Entities\Distributor;

class DistributorTransformer extends BaseTransformer
{
    /**
     * @OA\Schema(
     *     description="我的银行卡",
     *     type="object",
     *     schema="Distributor",
     *     @OA\Property(property="id", type="integer", description="ID"),
     *     @OA\Property(property="user_id", type="integer", description="用户ID"),
     *     @OA\Property(property="id_type", type="string", description="证件类型：身份证"),
     *     @OA\Property(property="true_name", type="string", description="真实姓名"),
     *     @OA\Property(property="phone", type="string", description="联系电话"),
     *     @OA\Property(property="id_card_no", type="string", description="身份证号码"),
     *     @OA\Property(property="id_card", type="string", description="身份证正面"),
     *     @OA\Property(property="id_card_back", type="string", description="身份证号码"),
     *     @OA\Property(property="status", type="integer", description="审核状态：0等待审核1审核成功2审核失败"),
     *     @OA\Property(property="created_at", type="string", description="添加时间"),
     *     @OA\Property(property="updated_at", type="string", description="更新时间"),
     * )
     */
    public function transform(Distributor $table)
    {
        return map_attr($table, [
            'id', 'user_id', 'id_type', 'true_name', 'phone', 'id_card_no', 'id_card', 'id_card_back', 'status', 'created_at', 'updated_at',
        ]) + ['is_distributor' => $table->status == 1];
    }
}
