<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/6/8
 * Time: 12:20
 */
namespace Modules\Project\Tranaformers;

use Modules\Project\Entities\Card;

class CardTransformer extends BaseTransformer
{
    /**
     * @OA\Schema(
     *     description="我的银行卡",
     *     type="object",
     *     schema="Card",
     *     @OA\Property(property="id", type="integer", description="ID"),
     *     @OA\Property(property="user_id", type="integer", description="用户ID"),
     *     @OA\Property(property="org", type="string", description="银行卡发卡机构"),
     *     @OA\Property(property="code", type="string", description="银行英文简称"),
     *     @OA\Property(property="type", type="string", description="DC为储蓄卡,CC为信用卡"),
     *     @OA\Property(property="name", type="string", description="持卡人姓名"),
     *     @OA\Property(property="number", type="string", description="银行卡卡号"),
     *     @OA\Property(property="branch", type="string", description="支行信息"),
     *     @OA\Property(property="phone", type="string", description="银行预留手机号"),
     *     @OA\Property(property="is_default", type="integer", description="是否是默认：0不是1是"),
     *     @OA\Property(property="created_at", type="string", description="注册时间"),
     *     @OA\Property(property="updated_at", type="string", description="更新时间"),
     *     @OA\Property(property="bank_logo", type="string", description="银行卡logo")
     * )
     */
    public function transform(Card $table)
    {
        return map_attr($table, [
            'id', 'user_id', 'org', 'code', 'type', 'name', 'number', 'branch', 'phone', 'is_default', 'created_at', 'updated_at',
            'bank_logo' => optional($table->bank)->logo,
        ]);
    }
}
