<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/6/13
 * Time: 9:53
 */
namespace Modules\Project\Services;

use Modules\Project\Entities\UserWithdraw;

class UserWithdrawService extends BaseService
{
    public function __construct(UserWithdraw $UserWithdraw, CardService $cardService)
    {
        $this->model = $UserWithdraw;
        $this->cardService = $cardService;
    }

    /**
     * 返回提现申请的状态文字内容
     *
     * @param $status
     *
     * @return string
     */
    public static function textStatus($status)
    {
        return self::$arrStatus[$status];
    }

    public function update($id, $data)
    {
        return parent::update($id, $data); // TODO: Change the autogenerated stub
    }

    public function find($id)
    {
        return $this->model->find($id);
    }

    public function delete($id)
    {
        $this->model = $this->model->find($id);

        return $this->model->delete($id);
    }

    public function insert($info)
    {
        $user_id = \Auth()->id();
        $card_id = $info['card_id'];
        $card = $this->cardService->model->find($card_id)->toArray();
        $data = [];
        $data['user_id'] = $user_id;
        $data['type'] = 'member';
        $data['money'] = $info['money'];
        $data['name'] = $card['name'];
        $data['number'] = $card['number'];
        $data['branch'] = $card['branch'];
        $data['phone'] = $card['phone'];
        $data['status'] = 0;

        return $this->model = $this->model->create($data);
    }

    public function htmlstatus($status)
    {
        $arrStatus = UserWithdraw::$arrStatus;

        switch ($status) {
            case 0:
                $show = '<span class="btn btn-sm btn-default">'.$arrStatus[$status].'</span>';
                break;
            case 1:
                $show = '<span class="btn btn-sm btn-primary">'.$arrStatus[$status].'</span>';
                break;
            case 2:
                $show = '<span class="btn btn-sm btn-success">'.$arrStatus[$status].'</span>';
                break;
            default:
                $show = '<span class="btn btn-sm btn-facebook">其它</span>';
                break;
        }

        return $show;
    }
}
