<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/6/13
 * Time: 9:53
 */
namespace Modules\Project\Services;

use Modules\Project\Entities\Transport;
use Modules\Project\Entities\TransportExtendArea;

class TransportService extends BaseService
{
    public function __construct(Transport $model)
    {
        $this->model = $model;
    }

    public static function getCityPreay($province_id)
    {
        $city = [
            'amount' => [
                'currency' => ['1', '南山区'],
                'default' => [0],
                'rules' => ['required|min:0.01'],
                'symbol' => ['￥'],
            ],
        ];

        return $city;
    }

    /*
     * 计算运费
     *
     */
    public function prepay($weight, $transport_id, $province_id)
    {
        //获取运输模板
        $post = TransportExtendArea::where('province_id', $province_id)->where('transport_id', $transport_id)->firstOrFail();
        $transportExtend = $post->transportExtend;
        $prepay = $this->back_prepay($weight, $transportExtend->snum, $transportExtend->sprice, $transportExtend->xnum, $transportExtend->xprice);
        $this->model = $transportExtend;
        $transportExtend->prepay = $prepay;

        return $prepay;
    }

    public function back_prepay($weight, $snum, $sprice, $xnum, $xprice)
    {
        if (!$weight || !$sprice) {
            return 0;
        }

        $prepay = $sprice;
        if ($weight > $snum) {
            $weight = ceil($weight);

            $prepay += $weight * 2 * $xprice - $xprice;
        }

        return $prepay;
    }
}
