<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/6/13
 * Time: 9:53
 */
namespace Modules\Project\Services;

use Modules\Project\Entities\UserCoupon;
use Modules\Project\Services\Counpon\UseCouponInterface;

class OrderCouponService extends BaseService implements UseCouponInterface
{
    protected $uid;

    protected $total;

    public function __construct(UserCoupon $model)
    {
        $this->model = $model;
    }

    public function setUID($uid)
    {
        $this->uid = $uid;
    }

    public function setTotal($total)
    {
        $this->total = $total;
    }

    public function getUID(): string
    {
        return $this->uid;
    }

    public function getTotal(): float
    {
        return $this->total;
    }

    public function userCoupon()
    {
        return $this->model->use($this);
    }

    public function canUseCoupon()
    {
        return $this->model->canUse($this);
    }
}
