<?php
namespace Modules\Project\Services\Order\Transport;

class TransportRow
{
    public $transport_id;

    public $transport_value;

    public $qty;

    public function __construct($data, $qty)
    {
        if ($data['transport_id'] && $data['transport_value'] && $data['transport_value']['weight']) {
            $this->transport_id = $data['transport_id'];

            $this->transport_value = $data['transport_value'];

            $this->qty = $qty;
        }
    }

    public function merge(self $transport)
    {
        if ($this->transport_id == $transport->transport_id) {
            $this->weight = $this->weight + $transport->weight;
        } else {
            throw new \Exception('无法合并');
        }

        return $this;
    }

    public function __get($name)
    {
        if ($name == 'weight') {
            return $this->transport_value['weight'];
        }
    }

    public function __set($name, $value)
    {
        if ($name == 'weight') {
            $this->transport_value['weight'] = $value;

            return $this->transport_value;
        }
    }
}
