<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/6/13
 * Time: 9:53
 */
namespace Modules\Project\Services;

use Gloudemans\Shoppingcart\Facades\Cart;
use Modules\Project\Entities\Goods;
use Modules\Project\Entities\GoodsList;

class GoodsCartService extends BaseService
{
    public function __construct()
    {
        $this->user_id = \Auth()->id();

        $this->model = Cart::instance('goods');

        //$this->model->restore($this->user_id);

        //$this->model->store($this->user_id);
    }

    //析构
    public function __destruct()
    {
        //$this->_store();
    }

    public function _addList($data)
    {
        //Cart::instance('goods')->restore($this->user_id);

        foreach ($data as $v) {
            $this->_addOrFail($v);
        }
    }

    public function _addOrFail($data)
    {
        $goods_id = $data['id'];

        $goods_info = Goods::findOrFail($goods_id);

        //$spec = $data['spec'];

        //$uuid = GoodsService::getSpecUuid($goods_id, $spec);

        //$goods_list_info = GoodsList::where('goods_id', $goods_id)->where('uuid', $uuid)->firstOrFail();

        $cart_data = [
            'id' => $data['id'],
            'name' => $goods_info->title,
            'price' => $goods_info->selling_price,
            //'options' => $spec,
            'qty' => $data['qty'],
        ];

        $this->model->add($cart_data)->associate(Goods::class);
    }

    public function _add($data)
    {
        $goods_id = $data['id'];

        $spec = $data['spec'];

        $cart_data = [
            'id' => $data['id'],
            'name' => 'name',
            'price' => '0',
            'options' => $data['spec'],
            'qty' => $data['qty'],
        ];

        $item = $this->model->add($cart_data);

        $item->associate(Goods::class);

        return $item;
    }

    public function _setList($data)
    {
        //Cart::instance('goods')->restore($this->user_id);

        $this->_destroy();

        foreach ($data as $v) {
            $this->_add($v);
        }
    }

    public function _update($row_id, $data)
    {
        $this->model->update($row_id, $data);
    }

    public function _destroy()
    {
        $this->model->destroy();
    }

    public function _content()
    {
        $content = $this->model->content();

        $res = [];
        $content->each(function ($v) use (&$res) {
            $uuid = GoodsService::getSpecUuid($v->id, $v->options->toArray());

            $goods_list_info = GoodsList::where('goods_id', $v->id)->where('uuid', $uuid)->get()->first();

            $goods_stock = $goods_list_info ? $goods_list_info->goods_stock : 0;

            if ($v->model) {
                $res[] = [

                    'goods_id' => $v->id,

                    'row_id' => $v->rowId,

                    'qty' => $v->qty,

                    'title' => $v->model->title,

                    'spec' => $v->options->toArray(),

                    'cover_picture' => $v->model->cover_picture,

                    'goods_stock' => $goods_stock,

                    'market_price' => $goods_list_info ? $goods_list_info->market_price : $v->model->market_price,

                    'selling_price' => $goods_list_info ? $goods_list_info->selling_price : $v->model->selling_price,

                ];
            } else {
                $res[] = [
                    'id' => $v->id,
                    'spec' => $v->options,
                    'qty' => $v->qty,
                    'title' => '商品已下架',
                    'status' => 0,
                ];
            }
        });

        return $res;
    }

    public function _store()
    {
        return $this->model->store($this->user_id);
    }

    public function _restore()
    {
        $this->model->restore($this->user_id);
    }

    public function _remove($row_id)
    {
        //Cart::instance('goods')->restore($this->user_id);

        return $this->model->remove($row_id);
    }
}
