<?php

namespace Modules\Project\Listeners;

use Modules\Base\Entities\Enrollment;
use SMG\Pay\Events\PaymentSuccessEvent;
use SMG\Pay\PayService;

class PaymentSuccessListener
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {

    }

    public function handle(PaymentSuccessEvent $event)
    {
        $model_type = $event->pay->model;//union

        if($model_type == 'enrollment_pay'){

            return $this->enrollment_pay($event);

        }

    }

    protected function enrollment_pay($event)
    {
        $enrollment_id = $event->pay->model_data;

        $info = Enrollment::find($enrollment_id);

        if($info){

            $info->pay_status = 1;

            $info->save();

        }
    }
}
