<?php

namespace Modules\Project\Listeners;

use SMG\Pay\PayService;

class EnrollmentCreatedListener
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {

    }

    /**
     * Handle the event.
     *
     * @return void
     */
    public function handle(\Modules\Base\Events\EnrollmentCreated $event)
    {
        $payService = new PayService();

        $payService->create(
            $event->enrollment->user_id,
            $event->enrollment->activity->price,
            'enrollment_'.$event->enrollment->id.'_'.$event->enrollment->user_id.'_'.date('ymd'),
            '活动报名支付',
            '',
            'enrollment_pay',
            $event->enrollment->id
        );
    }
}
