<?php

//前端
Route::group(['middleware' => 'web', 'prefix' => 'project', 'namespace' => 'Modules\Project\Http\Controllers'], function () {
    Route::get('/', 'IndexController@index');
});

//API
$api = app('Dingo\Api\Routing\Router');
$api->version(
    'v1',
    array_merge(
        [
            'namespace' => 'Modules\Project\Http\Controllers\Api',
            'prefix' => 'api',
        ],
        config('api.defaultSetting', [])
    ),
    function ($api) {
        $api->post('payment/notify', 'PaymentController@notify')->name('api.payment.notify');

        // 需要 token 验证的接口
        $api->group(['middleware' => 'api.auth'], function ($api) {

            //我的银行卡
            $api->get('card', 'CardController@index')
                ->name('api.card.index');

            //添加银行卡
            $api->post('card', 'CardController@store')
                ->name('api.card.store');

            //设为默认银行卡
            $api->put('card/{card_id}', 'CardController@update')
                ->name('api.card.update');

            //删除银行卡
            $api->delete('card/{card_id}', 'CardController@destroy')
                ->name('api.card.destroy');

            //我的钱包提现记录
            $api->get('user/withdraw', 'UserWithdrawController@index')
                ->name('api.user.withdraw.index');

            //我的钱包提现
            $api->post('user/withdraw', 'UserWithdrawController@store')
                ->name('api.user.withdraw.store');

            //我的收藏
            $api->get('user/favorites', 'FavoriteController@index');
            $api->post('user/favorites', 'FavoriteController@store');
            $api->delete('user/favorites', 'FavoriteController@destroy');

            //客户反馈
            $api->post('feedback', 'FeedbackController@store')
                ->name('api.feedback.store');

            //订单
            $api->get('orders', 'OrderController@index')->name('api.order.index');
            $api->post('orders/preview', 'OrderController@preview')->name('api.order.preview');
            $api->get('orders/{order_id}', 'OrderController@detail')->name('api.order.detail');
            $api->delete('orders/{order_id}', 'OrderController@destroy');

            $api->put('orders/{order_id}/cancel', 'OrderController@cancel')->name('api.order.cancel');
            $api->put('orders/{order_id}/confirm', 'OrderController@confirm')->name('api.order.confirm');
            $api->get('orders/{order_id}/logistics', 'OrderController@logistics')->name('api.order.logistics');

            //支付
            $api->post('payment/mini', 'PaymentController@mini')->name('api.payment.mini');
            $api->post('payment/balance', 'PaymentController@balance')->name('api.payment.balance');

            $api->group(['middleware' => \Modules\Base\Http\Middleware\StartSession::class], function ($api) {
                $api->post('orders', 'OrderController@store')->name('api.order.store');

                /*
                 * 购物车
                 */
                //列表
                $api->get('shoppingcart', 'ShoppingCartController@index')->name('api.shoppingcart');
                //新增
                $api->post('shoppingcart', 'ShoppingCartController@add')->name('api.shoppingcart.store');
                //设置
                $api->put('shoppingcart', 'ShoppingCartController@setCart')->name('api.shoppingcart');
                //删除
                $api->delete('shoppingcart/{row_id}', 'ShoppingCartController@remove')->name('api.shoppingcart.delete');
                //更新
                $api->put('shoppingcart/{row_id}', 'ShoppingCartController@update')->name('api.shoppingcart.update');
            });

            //申请分销员
            $api->post('user/distributors', 'DistributorController@store')->name('api.distributor.store');

            //用户优惠券
            $api->get('user/coupons', 'CouponController@me');
            $api->post('user/coupons', 'CouponController@store');

            //邀请的人
            $api->get('user/children', 'InvitationController@children');
            //邀请的人数量
            $api->get('user/children_count', 'InvitationController@childrenCount');

            //钱包余额
            $api->get('user/wallet/money', 'WalletController@money');
            //佣金赚取总数
            $api->get('user/wallet/reward', 'WalletController@orderRewardSum');
            //佣金赚取次数
            $api->get('user/wallet/reward_count', 'WalletController@orderRewardCount');
            //钱包变动日志
            $api->get('user/wallet/log', 'WalletController@log');
            //钱包某项类型总和
            $api->get('user/wallet/sum', 'WalletController@sum');
            //修改支付密码
            $api->put('user/wallet/pay_password', 'WalletController@update');
        });

        //首页
        $api->get('index', 'IndexController@index')
            ->name('api.index.index');

        //公共配置信息
        $api->get('configs', 'ConfigController@index')->name('api.configs');

        //商品分类的幻灯片
        $api->get('goods/categories/slider', 'GoodsCategoryController@slider')
            ->name('api.index.slider');

        //分类首页
        $api->get('goods/categories/index', 'GoodsCategoryController@index')
            ->name('api.goods.categories');

        $api->get('goods/categories/hot_search', 'GoodsCategoryController@hotSearch')
            ->name('api.goods.hot_search');

        //获取商品列表
        $api->get('goods', 'GoodsController@index')
            ->name('api.goods.index');

        //获取商品详情
        $api->get('goods/{goods_id}', 'GoodsController@detail')
            ->name('api.goods.detail');

        //优惠券
        $api->get('coupons', 'CouponController@index');

        //邀请图片
        $api->get('user/invitation_img', 'InvitationController@img');

        //快递运费
        $api->get('transport', 'TransportController@index');
        $api->get('transport/prepay', 'TransportController@prepay');
    }
);

/*
 * admin
 */
Route::group([
    'prefix' => config('admin.route.prefix'),
    'middleware' => config('admin.route.middleware'),
    'namespace' => 'Modules\Project\Http\Controllers\Admin',
], function ($router) {
    $router->post('/upload/pictures', 'UploadController@pictures');

    //商品
    $router->resource('/goods/goods', 'GoodsController');
    $router->resource('/goods/spec', 'GoodsSpecController');
    $router->get('/goods/category_list', 'GoodsController@getGoodsCategory');

    //订单
    $router->get('/order/transport', 'OrderController@transport');
    $router->resource('/order', 'OrderController');
    $router->post('/order/{id}/delivery', 'OrderController@delivery');

    //提现
    $router->get('/user/withdraw', 'UserWithdrawController@index');
    $router->get('/user/withdraw/{card_id}/edit', 'UserWithdrawController@edit');
    $router->put('/user/withdraw/{card_id}/update', 'UserWithdrawController@update');
    $router->delete('/user/withdraw/{card_id}', 'UserWithdrawController@destroy');
    $router->get('/user/withdraw_trash', 'UserWithdrawController@trash');

    //客户反馈
    $router->resource('/feedback', 'FeedbackController');

    //银行卡列表
    $router->resource('/bank', 'BankController');

    //优惠券
    $router->resource('/coupon', 'CouponController');

    //分销
    $router->resource('/distributor', 'DistributorController');

    //会员
    $router->resource('/user', 'UserController');
    $router->resource('/user/wallet', 'UserWalletController');
    $router->get('/user/wallet/log/{user_id}', 'UserWalletController@log');

    //物流
    $router->resource('/express', 'ExpressController');
    $router->resource('/transport', 'TransportController');
    $router->resource('/transport_extend', 'TransportExtendController');
});
