<?php

namespace Modules\Project\Http\Requests;

use Modules\Base\Http\Requests\BaseRequest;
use Modules\Base\Services\SmsService;

class WalletRequest extends BaseRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'PUT':
                $user = auth()->user();

                return [
                    'pay_password' => 'required|string|size:6',
                    'code' => 'required|string|check_sms:'.$user->phone.','.SmsService::SET_PAY_PASSWORD,
                ];
                break;
        }
    }
}
