<?php

namespace Modules\Project\Http\Requests;

use \Illuminate\Validation\Rule;
use Modules\Base\Http\Requests\BaseRequest;

class UserCouponRequest extends BaseRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            //我的优惠券
            case 'GET':
                return [
                    'status' => [
                        'required',
                        Rule::in(['available', 'expired', 'used']),
                    ],
                ];
            //领取优惠券
            case 'POST':
                return [
                    'coupon_id' => 'required|integer',
                ];
        }
    }
}
