<?php

namespace Modules\Project\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class TransportRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
                return [
                    'transport_id' => 'required|regex:/^[0-9]+$/',
                    'province_id' => 'required|regex:/^[0-9]+$/',
                    'weight' => 'required|regex:/^[0-9]+(\.[0-9]{1,2})?$/|gt:0',
                ];
                break;
        }
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }
}
