<?php

namespace Modules\Project\Http\Requests;

use Modules\Base\Http\Requests\BaseRequest;

class PaymentRequest extends BaseRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        if ($this->path() == 'api/payment/balance') {
            switch ($this->method()) {
                case 'POST':
                    return [
                        'order_id' => ['required','integer'],
                        'pay_password' => ['required','check_pay_password'],
                    ];
                    break;
            }
        }
    }

    public function attributes()
    {
        return [

        ];
    }

    public function messages()
    {
        return [

        ];
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }
}
