<?php

namespace Modules\Project\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class FeedbackRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        if (!isset($this->status)) {
            $this['status'] = 0;
        }
        switch ($this->method()) {
            case 'POST':
                $user = \Auth()->user();
                $user->user_id;

                $bool = $user->feedback()->where('reply', '')->exists();
                abort_if($bool, 403, '请勿重复提交');

                return [
                    'type' => 'required|string|max:50',
                    'remark' => 'required|string|max:250',
                ];
                break;
        }
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }
}
