<?php

namespace Modules\Project\Http\Requests;

use Modules\Base\Http\Requests\BaseRequest;
use Modules\Project\Entities\Bank;
use SMG\Support\Traits\HasHttpRequest;

class CardRequest extends BaseRequest
{
    use HasHttpRequest;

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $request = $this;
        if (!isset($this->is_default)) {
            $this['is_default'] = 0;
        }

        switch ($this->method()) {
            case 'POST':
                return [
                    'name' => 'required|string|between:2,25',
                    'number' => [
                        'required',
                        'unique:cards',
                        function ($attribute, $value, $fail) use ($request) {
                            $info = $this->get_bank_info($value);

                            if (is_array($info) && $info['validated']) {
                                //$return['code'] = $info['bank'];
                                //$return['type'] = $info['cardType'];
                                //request()->request->add(['code'=>$info['bank']]);
                                //request()->request->add(['type'=>$info['cardType']]);
                                $request['code'] = $info['bank'];
                                $request['type'] = $info['cardType'];
                                $request['org'] = Bank::where('code', $info['bank'])->value('org');
                            } else {
                                return $fail($attribute.' 银行卡验证失败'.json_encode($info['messages']).'.');
                            }
                        },
                    ],
                    'branch' => 'bail|required',
                    //'captcha_key' => 'required|string',
                    //'captcha_code' => 'bail|required|captcha_api:'.$this->captcha_key,
                    'phone' => 'bail|required|regex:/^1[345789][0-9]{9}$/',
                    'code' => 'bail|required_with:phone|string',
                ];

                break;
            case 'PUT':
                return [
                    'is_default' => 'bail|required|regex:/^1$/',
                ];
                break;
        }
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * 获取银行卡号接口参数
     *
     * @param string $card_number 银行卡号
     *
     * @return string
     */
    private function get_bank_info($card_number = '')
    {
        $url = 'https://ccdcapi.alipay.com/validateAndCacheCardInfo.json';
        $respond = $this->httpGet($url, [
            '_input_charset' => 'utf-8',
            'cardNo' => $card_number,
            'cardBinCheck' => 'true',
        ]);

        return $respond;
    }

    protected function getBaseOptions()
    {
        $options = [
            'base_uri' => method_exists($this, 'getBaseUri') ? $this->getBaseUri() : '',
            'timeout' => property_exists($this, 'timeout') ? $this->timeout : 5.0,
        ];
        $options['verify'] = false;

        return $options;
    }
}
