<?php

namespace Modules\Project\Http\Controllers\Api;

use Modules\Base\Http\Controllers\Api\ApiController;

class ConfigController extends ApiController
{
    /**
     * 配置信息
     *
     * @return mixed
     *
     * @OA\Get(
     *     tags={"基础接口"},
     *     summary="配置信息",
     *     path="/api/configs",
     *     @OA\Response(
     *          response="200",
     *          description="成功",
     *          @OA\MediaType(
     *             mediaType="application/json",
     *              @OA\Schema(
     *                  type="object",
     *                  @OA\Property(
     *                      property="data",
     *                      type="array",
     *                      @OA\Items(),
     *                      description="配置项"
     *                  ),
     *              )
     *          )
     *      )
     * )
     */
    public function index()
    {
        $config = [
            'order_reward_rate' => db_config('order_reward_rate', 0),
            'withdraw_notice' => db_config('withdraw_notice', ''),
        ];

        return $this->response->array(['data' => $config]);
    }
}
