<?php

namespace Modules\Project\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Modules\Base\Entities\User;
use Modules\Project\Entities\Order;
use Modules\Project\Entities\UserWallet;
use SMG\Admin\Controllers\ModelForm;
use SMG\Admin\Facades\Admin;
use SMG\Admin\Form;
use SMG\Admin\Grid;
use SMG\Admin\Layout\Content;
use SMG\Admin\Show;

class UserWalletController extends Controller
{
    use ModelForm;

    public function log($user_id, $type = 4)
    {
        $user = User::where('id', $user_id)->first();
        $parent = $user->parent();
        $log = $parent->walletLog(4);
        $reward = $log->get();
        $log_ids = $reward->pluck('id');
        $type_ids = $reward->pluck('type_id');
        $order = Order::where('user_id', $user_id);
        $order = $order->whereIn('id', $type_ids);
        $order = $order->get();
        $order_ids = $order->pluck('id');
        $sum = $log->whereIn('type_id', $order_ids)->sum('value');
        $return['valueCount'] = $sum;
        echo json_encode($return);
        exit;
    }

    /**
     * Index interface.
     *
     * @return Content
     */
    public function index()
    {
        return Admin::content(function (Content $content) {
            $content->header('Index');
            $content->description('description');

            $content->body($this->grid());
        });
    }

    /**
     * Show interface.
     *
     * @param $id
     *
     * @return Content
     */
    public function show($id)
    {
        return Admin::content(function (Content $content) use ($id) {
            $content->header('Detail');
            $content->description('description');

            $content->body(Admin::show(UserWallet::findOrFail($id), function (Show $show) {
                $show->id();

                $show->created_at();
                $show->updated_at();
            }));
        });
    }

    /**
     * Edit interface.
     *
     * @param $id
     *
     * @return Content
     */
    public function edit($id)
    {
        if (('div' == request('type')) && request()->method() == 'GET') {
            return $this->form()->edit($id);
        }

        return Admin::content(function (Content $content) use ($id) {
            $content->header('Edit');
            $content->description('description');

            $content->body($this->form()->edit($id));
        });
    }

    /**
     * Create interface.
     *
     * @return Content
     */
    public function create()
    {
        return Admin::content(function (Content $content) {
            $content->header('钱包');
            $content->description('增加');

            $content->body($this->form());
        });
    }

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Admin::grid(UserWallet::class, function (Grid $grid) {
            $grid->id('ID')->sortable();

            $grid->created_at();
            $grid->updated_at();
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Admin::form(UserWallet::class, function (Form $form) {
            $form->currency('value', '变动金额')->symbol('￥')->rules('required');
            $form->radio('type', '变动类型')->options([UserWallet::ADMIN_ADD => '增加'])->default(UserWallet::ADMIN_ADD);
            //$form->disableSubmit();
            //$form->disableReset();
        });
    }

    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'value' => 'required',
        ], [], $this->messages());
        if ($validator->fails()) {
            $errors = $validator->errors();
            foreach ($errors->all() as $message) {
                admin_toastr($message, 'error');
            }

            return redirect('admin/user/'.$id);
        }

        if ($request->type == UserWallet::ADMIN_ADD) {
            try {
                UserWallet::get($id)->addWallet($request->value, UserWallet::ADMIN_ADD);
                admin_toastr(trans('admin.update_succeeded'));
            } catch (\Exception $e) {
                $message = $e->getMessage();
                admin_toastr($message, 'error');
            }
        }

        return redirect('admin/user/'.$id);
    }

    /**
     * 获取已定义验证规则的错误消息。
     *
     * @return array
     */
    public function messages()
    {
        return [
            'value' => '金额',
        ];
    }
}
