<?php
namespace Modules\Project\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Dingo\Blueprint\Annotation\Request;
use Modules\Base\Entities\User;
use Modules\Project\Entities\UserWallet;
use Modules\Project\Entities\UserWalletLog;
use SMG\Admin\Controllers\ModelForm;
use SMG\Admin\Facades\Admin;
use SMG\Admin\Form;
use SMG\Admin\Grid;
use SMG\Admin\Layout\Content;
use SMG\Admin\Show;

class UserController extends Controller
{
    use ModelForm;

    /**
     * Index interface.
     *
     * @return Content
     */
    public function index()
    {
        return Admin::content(function (Content $content) {
            $content->header('会员');
            $content->description('说明');

            $content->body($this->grid());
        });
    }

    /**
     * Show interface.
     *
     * @param $id
     * @param $type
     *
     * @return Content
     */
    public function show($id, $type = '')
    {

        if (('children' == request('type')) || $type == 'children') {
            $user = User::where('id', $id)->first();
            $orderRewardSum = $user->walletLog(4)->sum('value');
            $childrenCount = $user->childrenCount();
            $parent = $user->parent();
            $children = $user->children();
            $assign = [];
            $assign = compact('children', 'parent', 'childrenCount', 'orderRewardSum');
            return view('admin.children',$assign);
        }
        Admin::addJs('/vendor/layui/layui.js','jQuery.getScript("/js/admin/user.js", function(){})');

        return Admin::content(function (Content $content) use ($id) {
            $content->header('会员');
            $content->description('详情');

            $content->body($this->tabform($id)->edit($id));
        });
    }

    public function show_user($id)
    {
        return  Admin::show(User::findOrFail($id), function (Show $show) use ($id) {
            $show->panel()->title('')->render();
            $show->id();
            $show->name('昵称');
            $show->phone('手机号');
            $show->email('邮箱');
            $show->field('avatar', '头像')->image()->wrapped = false;
            $show->created_at();
            $show->updated_at();
        });
    }

    public function tabform($id)
    {
        $grid = Admin::form(User::class, function (Form $form) use ($id) {
            $form->setTitle('详情');
            $form->tab('会员信息', function ($form) use ($id) {
                $form->html($this->show_user($id)->render())->setWidth(12, 0);
            });
            $form->tab('会员钱包', function ($form) use ($id) {
                $form->html($this->walletlogsgrid($id)->render())->setWidth(12, 0);
            });
            $form->tab('我的分销员', function ($form) use ($id) {
                $form->html($this->show($id,'children'))->setWidth(12, 0);
            });

            $form->setAction('#');
            $form->tools(function ($tools) {
            });
            $form->disableSubmit();
            $form->disableReset();
        });

        return $grid;
    }

    public function walletlogsgrid($id)
    {
        $grid = Admin::grid(UserWallet::class, function (Grid $grid) use ($id) {
            $user_wallet = (new UserWallet())->get($id);
            $grid->model()->find($id)->log();
            $grid->id('ID')->sortable();
            $grid->value('操作金额');
            $grid->type('变动类型')->display(function () {
                $Log = new UserWalletLog();
                $Log->type = $this->type;

                return $Log->getTypeNameAttribute();
            });
            $grid->type_id('变动类型id');
            $grid->wallet_type('钱包类型');
            $grid->created_at(trans('admin.created_at'));
            $grid->disableCreateButton();
            $grid->disableFilter();
            $grid->disableExport();
            $grid->disableRowSelector();
            $grid->disableActions();
            $grid->tools(function ($tools) use ($user_wallet) {
                $tools->append('<lable class="pull-right">钱包余额：<span>'.$user_wallet->money.'</span></lable>');
                $tools->append('<a class="btn btn-sm btn-success" onclick="add_money('.$user_wallet->user_id.');"><i class="fa fa-save"></i>&nbsp;&nbsp;增加</a>');
            });
        });

        return $grid;
    }

    /**
     * Edit interface.
     *
     * @param $id
     *
     * @return Content
     */
    public function edit($id)
    {
        return Admin::content(function (Content $content) use ($id) {
            $content->header('会员');
            $content->description('说明');

            $content->body($this->form()->edit($id));
        });
    }

    /**
     * Create interface.
     *
     * @return Content
     */
    public function create()
    {
        return Admin::content(function (Content $content) {
            $content->header('会员');
            $content->description('添加会员');
            $content->body($this->form());
        });
    }

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Admin::grid(User::class, function (Grid $grid) {
            $grid->setTitle('会员列表');
            $grid->id('ID')->sortable();
            $grid->column('name');
            $grid->phone('手机号');
            $grid->created_at();
            $grid->updated_at();
            $grid->enableFilter();
            $grid->disableExport();
            $grid->disableCreateButton();
            $grid->actions(function ($actions) {
                $actions->disableEdit();
                $actions->disableDelete();
            });
            $grid->filter(function ($filter) {
                // 去掉默认的id过滤器
                $filter->disableIdFilter();
                // 在这里添加字段过滤器
                $filter->like('name', '姓名');
                $filter->like('phone', '手机号');
            });
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Admin::form(User::class, function (Form $form) {
            $form->setTitle('编辑会员信息');
            $form->display('id', 'ID');

            $form->text('name', '用户名');
            $form->text('phone', '手机号')->rules('required|regex:/^1[345789][0-9]{9}$/');
            /*
            $form->password('password', trans('admin.password'))->rules('required|confirmed|min:6')
                ->default(function ($form) {
                    return $form->model()->password;
                });

            $form->password('password_confirmation', trans('admin.password_confirmation'))->rules('required')
                ->default(function ($form) {
                    return $form->model()->password;
                });

            $form->ignore(['password_confirmation']);
            */
            $form->text('email', '邮箱');
            $form->saving(function (Form $form) {
                if ($form->password && $form->model()->password != $form->password) {
                    $form->password = \Hash::make($form->password);
                }
            });
        });
    }

    /**
     * 获取已定义验证规则的错误消息。
     *
     * @return array
     */
    public function messages()
    {
        return [
            'password' => '密码是必填的',
        ];
    }
}
