<?php

namespace Modules\Project\Http\Controllers\Admin;

use Modules\Project\Entities\GoodsSpec;
use SMG\Admin\Controllers\ModelForm;
use SMG\Admin\Facades\Admin;
use SMG\Admin\Form;
use SMG\Admin\Grid;
use SMG\Admin\Layout\Content;

class GoodsSpecController
{
    use ModelForm;

    /**
     * Index interface.
     *
     * @return Content
     */
    public function index()
    {
        return Admin::content(function (Content $content) {
            $content->body($this->grid());
        });
    }

    /**
     * Edit interface.
     *
     * @param $id
     *
     * @return Content
     */
    public function edit($id)
    {
        return Admin::content(function (Content $content) use ($id) {
            $content->header('编辑');

            $content->description('编辑');

            $form = $this->form()->edit($id);

            $content->body($form);
        });
    }

    /**
     * Create interface.
     *
     * @return Content
     */
    public function create()
    {
        return Admin::content(function (Content $content) {
            $content->header('新增');

            $content->description('新增');

            $content->body($this->form());
        });
    }

    public function grid()
    {
        $grid = Admin::grid(GoodsSpec::class, function (Grid $grid) {
            $grid->id('ID');

            $grid->spec_name('标题');

            $grid->created_at('创建时间');

            $grid->updated_at('修改时间');
        });

        return $grid;
    }

    public function form()
    {
        return Admin::form(GoodsSpec::class, function (Form $form) {
            $form->display('id', 'ID');

            $form->text('spec_name', '规格名')->rules('required');

            $form->spec('spec_param', '规格参数')->rules('required')->help('多个规格请用英文逗号分隔，如有问题可以复制[,]括号中的逗号。', 'fa-info-circle');

            $form->textarea('spec_desc', '规格描述');

            $form->number('sort', '排序值')->default(100)->max(1000)->min(1)->help('数值越小排序越靠前', 'fa-info-circle');

            $form->display('created_at', '创建时间');

            $form->display('updated_at', '修改时间');
        });
    }
}
