<?php
namespace Modules\Project\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Modules\Base\Entities\User;
use Modules\Project\Entities\Feedback;
use SMG\Admin\Controllers\ModelForm;
use SMG\Admin\Facades\Admin;
use SMG\Admin\Form;
use SMG\Admin\Grid;
use SMG\Admin\Layout\Content;

class FeedbackController extends Controller
{
    use ModelForm;

    /**
     * Index interface.
     *
     * @return Content
     */
    public function index()
    {
        return Admin::content(function (Content $content) {
            $content->header('客户反馈');
            $content->description('说明');

            $content->body($this->grid());
        });
    }

    /**
     * Show interface.
     *
     * @param $id
     *
     * @return Content
     */
    public function show($id)
    {
        return Admin::content(function (Content $content) use ($id) {
            $content->header('Detail');
            $content->description('description');

            $content->body(Admin::show(Feedback::findOrFail($id), function (Show $show) {
                $show->id();

                $show->created_at();
                $show->updated_at();
            }));
        });
    }

    /**
     * Edit interface.
     *
     * @param $id
     *
     * @return Content
     */
    public function edit($id)
    {
        return Admin::content(function (Content $content) use ($id) {
            $content->header('Edit');
            $content->description('description');

            $content->body($this->form()->edit($id));
        });
    }

    /**
     * Create interface.
     *
     * @return Content
     */
    public function create()
    {
        return Admin::content(function (Content $content) {
            $content->header('Create');
            $content->description('description');

            $content->body($this->form());
        });
    }

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Admin::grid(Feedback::class, function (Grid $grid) {
            $grid->id('ID')->sortable();
            $grid->column('user.name');
            $grid->type('反馈类型');
            $grid->remark('反馈内容')->limit(30);
            $grid->reply('后台答复')->limit(30);
            $grid->admin_user('操作人');
            $grid->created_at();
            $grid->updated_at();
            $grid->disableCreateButton();
            $grid->disableFilter();
            $grid->disableExport();
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Admin::form(Feedback::class, function (Form $form) {
            $form->display('id', 'ID');
            $form->display('type', '反馈类型');
            $form->display('remark', '反馈内容');
            $form->textarea('reply', '答复');
            $form->display('created_at', 'Created At');
            $form->display('updated_at', 'Updated At');
        });
    }

    public function update(Request $request, $id)
    {
        //创建分组
        $this->validate($request, [
            'reply' => 'required',
        ], [], $this->messages());
        $admin = Admin::user();

        $table = Feedback::findorFail($id);
        $table->admin_user = $admin->username;
        $table->reply = $request->reply;
        $table->save();
        admin_toastr(trans('admin.update_succeeded'));

        return redirect('admin/feedback');
    }

    /**
     * 获取已定义验证规则的错误消息。
     *
     * @return array
     */
    public function messages()
    {
        return [
            'reply' => '答复是必填的',
        ];
    }
}
