<?php
namespace Modules\Project\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Modules\Project\Entities\Distributor;
use Modules\Project\Entities\Feedback;
use SMG\Admin\Controllers\ModelForm;
use SMG\Admin\Facades\Admin;
use SMG\Admin\Form;
use SMG\Admin\Grid;
use SMG\Admin\Layout\Content;

class DistributorController extends Controller
{
    use ModelForm;

    /**
     * Index interface.
     *
     * @return Content
     */
    public function index()
    {
        return Admin::content(function (Content $content) {
            $content->header('分销管理');
            $content->description('申请分销员列表');

            $content->body($this->grid());
        });
    }

    /**
     * Show interface.
     *
     * @param $id
     *
     * @return Content
     */
    public function show($id)
    {
        return Admin::content(function (Content $content) use ($id) {
            $content->header('Detail');
            $content->description('description');

            $content->body(Admin::show(Feedback::findOrFail($id), function (Show $show) {
                $show->id();

                $show->created_at();
                $show->updated_at();
            }));
        });
    }

    /**
     * Edit interface.
     *
     * @param $id
     *
     * @return Content
     */
    public function edit($id)
    {
        Admin::script("
            $('.$id-delete').unbind('click').click(function() {
                swal({
                  title: '确认删除?',
                  type: 'warning',
                  showCancelButton: true,
                  confirmButtonColor: '#DD6B55',
                  confirmButtonText: '确认',
                  closeOnConfirm: false,
                  cancelButtonText: '取消'
                },
                function(){
                    $.ajax({
                        method: 'post',
                        url: '/admin/distributor/$id',
                        data: {
                            _method:'delete',
                            _token:LA.token,
                        },
                        success: function (data) {
                            $.pjax({container:'#pjax-container', url: '/admin/distributor' });

                            if (typeof data === 'object') {
                                if (data.status) {
                                    swal(data.message, '', 'success');
                                } else {
                                    swal(data.message, '', 'error');
                                }
                            }
                        }
                    });
                });
            });
        ");

        return Admin::content(function (Content $content) use ($id) {
            $content->header('审核');
            $content->description('分销员资格审核');

            $content->body($this->form()->edit($id));
        });
    }

    /**
     * Create interface.
     *
     * @return Content
     */
    public function create()
    {
        return Admin::content(function (Content $content) {
            $content->header('Create');
            $content->description('description');

            $content->body($this->form());
        });
    }

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Admin::grid(Distributor::class, function (Grid $grid) {
            $grid->id('ID')->sortable();
            $grid->column('user.name');
            $grid->true_name('姓名');
            $grid->phone('手机号');
            $grid->column('status', '审核状态')->editable('select', Distributor::$arrStatus);
            $grid->created_at();
            $grid->updated_at();
            $grid->disableCreateButton();
            $grid->enableFilter();
            $grid->disableExport();
            $grid->disableRowSelector();
            $grid->actions(function ($actions) {
                $actions->disableView();
                $actions->disableDelete();
            });
            $grid->filter(function ($filter) {
                // 去掉默认的id过滤器
                $filter->disableIdFilter();
                // 在这里添加字段过滤器
                $filter->like('true_name', '姓名');
                $filter->equal('status', '申请状态')->select(Distributor::$arrStatus);
            });
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Admin::form(Distributor::class, function (Form $form) {
            $id = request()->route('distributor');
            $row = Distributor::find($id);

            $form->display('id', 'ID');
            $form->display('id_type', '证件类型');
            $form->display('true_name', '真实姓名');
            $form->display('phone', '联系电话');
            $form->display('id_card_no', '身份证号码');
            $folder = config('upload.distributor.folder');
            $id_card = '<div class="col-sm-6"><img src="'.get_file_url($row->id_card, $folder).'" /></div>';
            $id_card_back = '<div class="col-sm-6"><img src="'.get_file_url($row->id_card_back, $folder).'" /></div>';

            $form->html($id_card.$id_card_back, '身份证正反面');
            $form->radio('status', '审核状态?')->options(Distributor::$arrStatus)->default($row->status)->help('如果审核失败，允许用户再次提交，请删除本次提交');

            if (in_array($row->status, Distributor::$lockStatus)) {
                $form->disableReset();
                $form->disableSubmit();
            }

            $form->tools(function ($tools) use ($id) {
                $tools->add('<div class="btn-group" style="margin-right: 5px;"><a class="btn btn-sm btn-danger '.$id.'-delete " href="javascript:void(0);"><i class="fa fa-trash"></i>&nbsp;&nbsp;删除</a></div>');
            });
        });
    }
}
