<?php
namespace Modules\Project\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Modules\Project\Entities\Bank;
use SMG\Admin\Controllers\ModelForm;
use SMG\Admin\Facades\Admin;
use SMG\Admin\Form;
use SMG\Admin\Grid;
use SMG\Admin\Layout\Content;

class BankController extends Controller
{
    use ModelForm;

    /**
     * Index interface.
     *
     * @return Content
     */
    public function index()
    {
        return Admin::content(function (Content $content) {
            $content->header('银行卡列表');
            $content->description('说明');

            $content->body($this->grid());
        });
    }

    /**
     * Show interface.
     *
     * @param $id
     *
     * @return Content
     */
    public function show($id)
    {
        return Admin::content(function (Content $content) use ($id) {
            $content->header('Detail');
            $content->description('description');

            $content->body(Admin::show(Feedback::findOrFail($id), function (Show $show) {
                $show->id();

                $show->created_at();
                $show->updated_at();
            }));
        });
    }

    /**
     * Edit interface.
     *
     * @param $id
     *
     * @return Content
     */
    public function edit($id)
    {
        return Admin::content(function (Content $content) use ($id) {
            $content->header('Edit');
            $content->description('description');

            $content->body($this->form($id)->edit($id));
        });
    }

    /**
     * Create interface.
     *
     * @return Content
     */
    public function create()
    {
        return Admin::content(function (Content $content) {
            $content->header('Create');
            $content->description('description');

            $content->body($this->form());
        });
    }

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Admin::grid(Bank::class, function (Grid $grid) {
            $grid->id('ID')->sortable();
            $grid->org('发卡机构');
            $grid->code('英文简称');
            $grid->logo('图标地址')->display(function ($name) {
                return '<img src='.\Illuminate\Support\Facades\Storage::disk(config('admin.upload.disk'))->url($name)." style='width: 30px;'/>";
            });

            $grid->created_at();
            $grid->updated_at();
            $grid->disableCreateButton();
            $grid->disableActions();
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Admin::form(Bank::class, function (Form $form) {
            $id = request()->route('bank');
            $table = $form->model()->find($id);
            $form->display('id', 'ID');
            $form->text('org', '发卡机构');
            $form->text('code', '英文简称');
            $form->image('logo', '图标')->move('/banks/')->name(function ($file) use ($table) {
                return $table->code.'.'.$file->guessExtension();
            });

            $form->display('created_at', 'Created At');
            $form->display('updated_at', 'Updated At');
        });
    }
}
