<?php

namespace Modules\Project\Entities;

use Illuminate\Database\Eloquent\Model;

class Express extends Model
{
    protected $fillable = [
        'name', 'code',
    ];

    public function getBase64LogoAttribute()
    {
        return $this->getLogoBase64();
    }

    protected function getLogoBase64()
    {
        $key = 'logo_'.$this->code;

        $cache = cache($key);

        if (!empty($cache)) {
            return $cache;
        } else {
            $src = 'http://cdn.ickd.cn/www/images/logo/'.$this->code.'.jpg';

            $body = base64_encode(file_get_contents($src));

            cache([$key => $body], 0);

            return $body;
        }
    }
}
