<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddTransportToGoodsTable201808161836 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('goods', function (Blueprint $table) {
            $table->integer('transport_id')->nullable()->comment("快递模板id");
            $table->json('transport_value')->nullable()->comment('快递模板的所需值 json 如：{weight:"10"}');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('goods', function (Blueprint $table) {
            $table->dropColumn('transport_value');
            $table->dropColumn('transport_id');
        });
    }
}
