<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUserWalletLogsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('user_wallet_logs', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('user_id')->index()->comment('用户ID');
            $table->decimal('value', 10, 2)->comment('数值');
            $table->tinyInteger('type')->default(1)->comment('变动类型，具体在UserWalletServive查看');
            $table->integer('type_id')->defalut(0)->index()->comment('变动类型ID');
            $table->string('wallet_type')->index()->default('money')->comment('钱包类型');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('user_wallet_logs');
    }
}
