<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTransportExtendsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('transport_extends', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('transport_id')->comment('快递模板ID');
            $table->string('area_id')->comment('市级地区ID组成的串，以，隔开，两端也有');
            $table->string('top_area_id')->comment('省级地区ID组成的串，以，隔开，两端也有');
            $table->text('area_name')->comment('地区name组成的串，以，隔开');
            $table->mediumInteger('snum')->default(1)->comment('首重');
            $table->decimal('sprice')->default(0)->comment('首重');
            $table->mediumInteger('xnum')->default(1)->comment('续重');
            $table->decimal('xprice')->default(0)->comment('续重运费');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('transport_extends');
    }
}
