<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDistributorsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('distributors', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('user_id')->index()->comment('用户ID');
            $table->string('id_type',50)->comment('证件类型：身份证');
            $table->string('true_name',50)->comment('真实姓名');
            $table->string('phone',50)->comment('联系电话');
            $table->string('id_card_no',50)->comment('身份证号码');
            $table->string('id_card',255)->comment('身份证正面');
            $table->string('id_card_back',255)->comment('身份证反面');
            $table->tinyInteger('status')->default(0)->comment('审核状态：0等待审核1审核成功2审核失败');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('distributors');
    }
}
