<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class NewCreateBanksTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::dropIfExists('banks');
        Schema::create('banks', function (Blueprint $table) {
            $table->increments('id');
            $table->string('org',50)->comment('银行卡发卡机构');
            $table->string('code',50)->comment('银行英文简称');
            $table->string('logo',100)->comment('银行logo');
            $table->tinyInteger('status')->comment('银行显示状态， 1正常显示  隐藏');

            $table->timestamps();
        });
        DB::table('banks')->insert([
                [
                    'org' => '招商银行',
                    'code' => 'CMB',
                    'logo' => 'banks/CMB.png',
                    'status' => 1,
                    'created_at' => '2017-7-16 07:35:12',
                    'updated_at' => '2016-7-16 07:35:12',
                ],
                [
                    'org' => '中国建设银行',
                    'code' => 'CCB',
                    'logo' => 'banks/CCB.png',
                    'status' => 1,
                    'created_at' => '2017-7-16 07:35:12',
                    'updated_at' => '2016-7-16 07:35:12',
                ],
                [
                    'org' => '交通银行',
                    'code' => 'COMM',
                    'logo' => 'banks/COMM.png',
                    'status' => 1,
                    'created_at' => '2017-7-16 07:35:12',
                    'updated_at' => '2016-7-16 07:35:12',
                ],
                [
                    'org' => '交通银行',
                    'code' => 'BOCM',
                    'logo' => 'banks/BOCM.png',
                    'status' => 1,
                    'created_at' => '2017-7-16 07:35:12',
                    'updated_at' => '2016-7-16 07:35:12',
                ],
                [
                    'org' => '交通银行',
                    'code' => 'BOCOM',
                    'logo' => 'banks/BOCOM.png',
                    'status' => 1,
                    'created_at' => '2017-7-16 07:35:12',
                    'updated_at' => '2016-7-16 07:35:12',
                ],
                [
                    'org' => '上海银行',
                    'code' => 'SHBANK',
                    'logo' => 'banks/SHBANK.png',
                    'status' => 1,
                    'created_at' => '2017-7-16 07:35:12',
                    'updated_at' => '2016-7-16 07:35:12',
                ],
                [
                    'org' => '中国邮政储蓄银行',
                    'code' => 'PSBC',
                    'logo' => 'banks/PSBC.png',
                    'status' => 1,
                    'created_at' => '2017-7-16 07:35:12',
                    'updated_at' => '2016-7-16 07:35:12',
                ],
                [
                    'org' => '北京银行',
                    'code' => 'BJBANK',
                    'logo' => 'banks/BJBANK.png',
                    'status' => 1,
                    'created_at' => '2017-7-16 07:35:12',
                    'updated_at' => '2016-7-16 07:35:12',
                ],
                [
                    'org' => '中国银行',
                    'code' => 'BOC',
                    'logo' => 'banks/BOC.png',
                    'status' => 1,
                    'created_at' => '2017-7-16 07:35:12',
                    'updated_at' => '2016-7-16 07:35:12',
                ],
                [
                    'org' => '中国工商银行',
                    'code' => 'ICBC',
                    'logo' => 'banks/ICBC.png',
                    'status' => 1,
                    'created_at' => '2017-7-16 07:35:12',
                    'updated_at' => '2016-7-16 07:35:12',
                ],
                [
                    'org' => '中国银行',
                    'code' => 'BOC',
                    'logo' => 'banks/BOC.png',
                    'status' => 1,
                    'created_at' => '2017-7-16 07:35:12',
                    'updated_at' => '2016-7-16 07:35:12',
                ],
                [
                    'org' => '广发银行',
                    'code' => 'GDB',
                    'logo' => 'banks/GDB.png',
                    'status' => 1,
                    'created_at' => '2017-7-16 07:35:12',
                    'updated_at' => '2016-7-16 07:35:12',
                ],
                [
                    'org' => '中国民生银行',
                    'code' => 'CMBC',
                    'logo' => 'banks/CMBC.png',
                    'status' => 1,
                    'created_at' => '2017-7-16 07:35:12',
                    'updated_at' => '2016-7-16 07:35:12',
                ],
                [
                    'org' => '宁波银行',
                    'code' => 'NBBANK',
                    'logo' => 'banks/NBBANK.png',
                    'status' => 1,
                    'created_at' => '2017-7-16 07:35:12',
                    'updated_at' => '2016-7-16 07:35:12',
                ],
                [
                    'org' => '浦发银行',
                    'code' => 'SPDB',
                    'logo' => 'banks/SPDB.png',
                    'status' => 1,
                    'created_at' => '2017-7-16 07:35:12',
                    'updated_at' => '2016-7-16 07:35:12',
                ],
                [
                    'org' => '深圳发展银行',
                    'code' => 'SDB',
                    'logo' => 'banks/SDB.png',
                    'status' => 1,
                    'created_at' => '2017-7-16 07:35:12',
                    'updated_at' => '2016-7-16 07:35:12',
                ],
                [
                    'org' => '中国光大银行',
                    'code' => 'CEB',
                    'logo' => 'banks/CEB.png',
                    'status' => 1,
                    'created_at' => '2017-7-16 07:35:12',
                    'updated_at' => '2016-7-16 07:35:12',
                ],
                [
                    'org' => '平安银行',
                    'code' => 'SPABANK',
                    'logo' => 'banks/SPABANK.png',
                    'status' => 1,
                    'created_at' => '2017-7-16 07:35:12',
                    'updated_at' => '2016-7-16 07:35:12',
                ],
                [
                    'org' => '华夏银行',
                    'code' => 'HXBANK',
                    'logo' => 'banks/HXBANK.png',
                    'status' => 1,
                    'created_at' => '2017-7-16 07:35:12',
                    'updated_at' => '2016-7-16 07:35:12',
                ],
                [
                    'org' => '中信银行',
                    'code' => 'CITIC',
                    'logo' => 'banks/CITIC.png',
                    'status' => 1,
                    'created_at' => '2017-7-16 07:35:12',
                    'updated_at' => '2016-7-16 07:35:12',
                ],
                [
                    'org' => '中国农业银行',
                    'code' => 'ABC',
                    'logo' => 'banks/ABC.png',
                    'status' => 1,
                    'created_at' => '2017-7-16 07:35:12',
                    'updated_at' => '2016-7-16 07:35:12',
                ],
                [
                    'org' => '兴业银行',
                    'code' => 'CIB',
                    'logo' => 'banks/CIB.png',
                    'status' => 1,
                    'created_at' => '2017-7-16 07:35:12',
                    'updated_at' => '2016-7-16 07:35:12',
                ],
              
            ]
        );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('banks');
    }
}
