<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBanksTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('banks', function (Blueprint $table) {
            $table->increments('id');
            $table->string('org',50)->comment('银行卡发卡机构');
            $table->string('code',50)->comment('银行英文简称');
            $table->string('logo',100)->comment('银行logo');
            $table->tinyInteger('status')->comment('银行显示状态， 1正常显示  隐藏');

            $table->timestamps();
        });

        DB::table('banks')->insert([
                [
                    'org' => '招商银行',
                    'code' => 'CMB',
                    'logo' => '/image/bank/CMB.png',
                    'status' => 1,
                    'created_at' => '2017-7-16 07:35:12',
                    'updated_at' => '2016-7-16 07:35:12',
                ],
                [
                    'org' => '中国建设银行',
                    'code' => 'CCB',
                    'logo' => '/image/bank/CCB.png',
                    'status' => 1,
                    'created_at' => '2017-7-16 07:35:12',
                    'updated_at' => '2016-7-16 07:35:12',
                ],
                [
                    'org' => '交通银行',
                    'code' => 'COMM',
                    'logo' => '/image/bank/COMM.png',
                    'status' => 1,
                    'created_at' => '2017-7-16 07:35:12',
                    'updated_at' => '2016-7-16 07:35:12',
                ],
                [
                    'org' => '交通银行',
                    'code' => 'BOCM',
                    'logo' => '/image/bank/BOCM.png',
                    'status' => 1,
                    'created_at' => '2017-7-16 07:35:12',
                    'updated_at' => '2016-7-16 07:35:12',
                ],
                [
                    'org' => '交通银行',
                    'code' => 'BOCOM',
                    'logo' => '/image/bank/BOCOM.png',
                    'status' => 1,
                    'created_at' => '2017-7-16 07:35:12',
                    'updated_at' => '2016-7-16 07:35:12',
                ],
                [
                    'org' => '上海银行',
                    'code' => 'SHBANK',
                    'logo' => '/image/bank/SHBANK.png',
                    'status' => 1,
                    'created_at' => '2017-7-16 07:35:12',
                    'updated_at' => '2016-7-16 07:35:12',
                ],
                [
                    'org' => '中国邮政储蓄银行',
                    'code' => 'PSBC',
                    'logo' => '/image/bank/PSBC.png',
                    'status' => 1,
                    'created_at' => '2017-7-16 07:35:12',
                    'updated_at' => '2016-7-16 07:35:12',
                ],
                [
                    'org' => '北京银行',
                    'code' => 'BJBANK',
                    'logo' => '/image/bank/BJBANK.png',
                    'status' => 1,
                    'created_at' => '2017-7-16 07:35:12',
                    'updated_at' => '2016-7-16 07:35:12',
                ],
                [
                    'org' => '中国银行',
                    'code' => 'BOC',
                    'logo' => '/image/bank/BOC.png',
                    'status' => 1,
                    'created_at' => '2017-7-16 07:35:12',
                    'updated_at' => '2016-7-16 07:35:12',
                ],
                [
                    'org' => '中国工商银行',
                    'code' => 'ICBC',
                    'logo' => '/image/bank/ICBC.png',
                    'status' => 1,
                    'created_at' => '2017-7-16 07:35:12',
                    'updated_at' => '2016-7-16 07:35:12',
                ],
                [
                    'org' => '中国银行',
                    'code' => 'BOC',
                    'logo' => '/image/bank/BOC.png',
                    'status' => 1,
                    'created_at' => '2017-7-16 07:35:12',
                    'updated_at' => '2016-7-16 07:35:12',
                ],
                [
                    'org' => '广发银行',
                    'code' => 'GDB',
                    'logo' => '/image/bank/GDB.png',
                    'status' => 1,
                    'created_at' => '2017-7-16 07:35:12',
                    'updated_at' => '2016-7-16 07:35:12',
                ],
                [
                    'org' => '中国民生银行',
                    'code' => 'CMBC',
                    'logo' => '/image/bank/CMBC.png',
                    'status' => 1,
                    'created_at' => '2017-7-16 07:35:12',
                    'updated_at' => '2016-7-16 07:35:12',
                ],
                [
                    'org' => '宁波银行',
                    'code' => 'NBBANK',
                    'logo' => '/image/bank/NBBANK.png',
                    'status' => 1,
                    'created_at' => '2017-7-16 07:35:12',
                    'updated_at' => '2016-7-16 07:35:12',
                ],
                [
                    'org' => '浦发银行',
                    'code' => 'SPDB',
                    'logo' => '/image/bank/SPDB.png',
                    'status' => 1,
                    'created_at' => '2017-7-16 07:35:12',
                    'updated_at' => '2016-7-16 07:35:12',
                ],
                [
                    'org' => '深圳发展银行',
                    'code' => 'SDB',
                    'logo' => '/image/bank/SDB.png',
                    'status' => 1,
                    'created_at' => '2017-7-16 07:35:12',
                    'updated_at' => '2016-7-16 07:35:12',
                ],
                [
                    'org' => '中国光大银行',
                    'code' => 'CEB',
                    'logo' => '/image/bank/CEB.png',
                    'status' => 1,
                    'created_at' => '2017-7-16 07:35:12',
                    'updated_at' => '2016-7-16 07:35:12',
                ],
                [
                    'org' => '平安银行',
                    'code' => 'SPABANK',
                    'logo' => '/image/bank/SPABANK.png',
                    'status' => 1,
                    'created_at' => '2017-7-16 07:35:12',
                    'updated_at' => '2016-7-16 07:35:12',
                ],
                [
                    'org' => '华夏银行',
                    'code' => 'HXBANK',
                    'logo' => '/image/bank/HXBANK.png',
                    'status' => 1,
                    'created_at' => '2017-7-16 07:35:12',
                    'updated_at' => '2016-7-16 07:35:12',
                ],
                [
                    'org' => '中信银行',
                    'code' => 'CITIC',
                    'logo' => '/image/bank/CITIC.png',
                    'status' => 1,
                    'created_at' => '2017-7-16 07:35:12',
                    'updated_at' => '2016-7-16 07:35:12',
                ],
                [
                    'org' => '中国农业银行',
                    'code' => 'ABC',
                    'logo' => '/image/bank/ABC.png',
                    'status' => 1,
                    'created_at' => '2017-7-16 07:35:12',
                    'updated_at' => '2016-7-16 07:35:12',
                ],
                [
                    'org' => '兴业银行',
                    'code' => 'CIB',
                    'logo' => '/image/bank/CIB.png',
                    'status' => 1,
                    'created_at' => '2017-7-16 07:35:12',
                    'updated_at' => '2016-7-16 07:35:12',
                ],
                [
                    'org' => '常熟农商银行',
                    'code' => 'CSRCB',
                    'logo' => '/image/bank/CSRCB.png',
                    'status' => 1,
                    'created_at' => '2017-7-16 07:35:12',
                    'updated_at' => '2016-7-16 07:35:12',
                ],
            ]
        );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('banks');
    }
}
