<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOrderTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->increments('id');
			$table->unsignedInteger('user_id')->comment('用户id');
			$table->decimal('goods_price',10,2)->comment('商品价格');
			$table->decimal('discount_amount',10,2)->comment('优惠金额');
			$table->decimal('payable_amount',10,2)->comment('应付金额');
			$table->decimal('paid_amount',10,2)->comment('已支付金额');
			$table->unsignedInteger('status')->comment('订单状态 1：待支付 2:取消订单 3：已支付');
			$table->string('remarks')->comment('订单备注');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('orders');
    }
}
