<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateGoodsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('goods', function (Blueprint $table) {
            $table->increments('id');
            $table->string('title')->comment('标题');
			$table->text('pictures')->comment('图片');
			$table->integer('spec_id')->nullable()->comment('规格id');
			$table->json('spec_param')->nullable()->comment('规格');
			$table->decimal('market_price',10,2)->comment('市场价');
			$table->decimal('selling_price',10,2)->comment('售价');
			$table->integer('goods_stock')->comment('库存')->default('0');
			$table->integer('goods_sale')->comment('已销售数量')->default('0');
			$table->text('description')->comment('描述')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('goods');
    }
}
