<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateGoodsSpecTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        Schema::create('goods_specs', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('mch_id')->comment('商家id')->nullable();
            $table->string('spec_name')->comment('规格名');
            $table->string('spec_param')->comment('规格参数 规格值 如：颜色1 颜色2');
            $table->string('spec_desc')->comment('规格描述')->nullable();
            $table->integer('sort')->comment('排序');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('goods_specs');
    }
}
