<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateGoodsListTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('goods_lists', function (Blueprint $table) {
            $table->increments('id');
			$table->integer('goods_id')->comment('商品id');
            $table->json('spec')->comment('规格');
            $table->decimal('market_price',10,2)->comment('市场价');
            $table->decimal('selling_price',10,2)->comment('售价');
            $table->integer('goods_stock')->comment('库存');
            $table->integer('goods_sale')->comment('已销售数量');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('goods_lists');
    }
}
